     %  This MATLAB program computes the DFT using the defining 
     %  equations (12.43) for the transform pair.

     N = input...
          ('How many discrete-time samples are in the sequence?' )

     x =input...
          ('Type the vector of samples, in brackets [...]:' )

     %  Compute the DFT from (12.43)
     for k1 = 1:N
          X(k1) = 0;
          k = k1-1;
          for n1 = 1:N;
               n = n1-1;
               X(k1) = X(k1) + x(n1)*exp(j*2*pi*k*n/N);
          end
     end
     x
     X

