% This program multiplies two sinusoidal signals together
% and computes the Fourier transform of the product to 
% confirm the result of Example 5.9.

% Generate a time vector.
t = 0.0005*(1:256);

% Generate the two sinusoids.
for n=1:256
        g1(n) = 2*cos(200*pi*t(n));
        g2(n) = 5*cos(1000*pi*t(n));
end

% Multiply the sinusoidal signals.
g3 = g1.*g2;

% Approximate the Fourier transform of the product.
G3 = 0.0005*fft(g3,256);

% Generate a frequency vector.
fr = 2*pi*(1:127)/(0.0005*256);

% Plot the positive side of the frequency spectrum.
G3p = G3(1:127);
plot(fr,abs(G3p)),title('Frequency Spectrum'),grid
xlabel('omega')
ylabel('magnitude')
