
    % This MATLAB program generates a DSB/SC-AM signal and 
    % its frequency spectrum.

    % generate a time vector of 256 elements in .01s steps.
    t = .01*(1:256);

    % generate the message signal m(t)=2cos(20t)+sin(4t)
    m= 2*cos(20*pi*t) + sin(4*pi*t);
    plot(t,m),title('Message Signal'),grid,pause

    % modulate a carrier signal, cos(200t, with m(t).
    c = m.*cos(100*pi*t);
    plot(t,c),title('DSB/SC-AM Signal'),grid,pause

    % use the fft function to approximate the Fourier 
    % transform of the modulated signal.
    Cf = fft(c,256);
    
    % generate a frequency vector of 256 elements.
    f = 2*pi*(1:256)/(256*.01);

    % plot the magnitude spectrum of the modulated signal
    plot(f,abs(Cf)),title('DSB/SC-AM Frequency Spectrum')
    grid

