
    % This MATLAB program generates a Butterworth filter of
    % specified order and displays the Bode plot of the 
    % magnitude frequency response.

    N=input...
         ('Specify the order of the filter:')

    z_p_k='The zeros, poles and multiplying constant.'
    [z,p,k] = buttap(N), pause

    num_den='The numerator and denominator coefficients.'
    [num,den]=zp2tf(z,p,k),pause

    [mag,phase,w] = bode(num,den);

    plot(w,mag)
    title(['Magnitude Bode plot ',num2str(N),...
         'th order Butterworth filter'])
    xlabel('omega')
    ylabel('Magnitude')
