function [ret,x0,str,ts,xts]=butlpex2(t,x,u,flag);
%BUTLPEX2	is the M-file description of the SIMULINK system named BUTLPEX2.
%	The block-diagram can be displayed by typing: BUTLPEX2.
%
%	SYS=BUTLPEX2(T,X,U,FLAG) returns depending on FLAG certain
%	system values given time point, T, current state vector, X,
%	and input vector, U.
%	FLAG is used to indicate the type of output to be returned in SYS.
%
%	Setting FLAG=1 causes BUTLPEX2 to return state derivatives, FLAG=2
%	discrete states, FLAG=3 system outputs and FLAG=4 next sample
%	time. For more information and other options see SFUNC.
%
%	Calling BUTLPEX2 with a FLAG of zero:
%	[SIZES]=BUTLPEX2([],[],[],0),  returns a vector, SIZES, which
%	contains the sizes of the state vector and other parameters.
%		SIZES(1) number of states
%		SIZES(2) number of discrete states
%		SIZES(3) number of outputs
%		SIZES(4) number of inputs
%		SIZES(5) number of roots (currently unsupported)
%		SIZES(6) direct feedthrough flag
%		SIZES(7) number of sample times
%
%	For the definition of other parameters in SIZES, see SFUNC.
%	See also, TRIM, LINMOD, LINSIM, EULER, RK23, RK45, ADAMS, GEAR.

% Note: This M-file is only used for saving graphical information;
%       after the model is loaded into memory an internal model
%       representation is used.

% the system will take on the name of this mfile:
sys = mfilename;
new_system(sys)
simver(1.3)
if (0 == (nargin + nargout))
     set_param(sys,'Location',[85,66,585,366])
     open_system(sys)
end;
set_param(sys,'algorithm',     'RK-45')
set_param(sys,'Start time',    '0.0')
set_param(sys,'Stop time',     '999999')
set_param(sys,'Min step size', '0.001')
set_param(sys,'Max step size', '0.0010')
set_param(sys,'Relative error','1e-3')
set_param(sys,'Return vars',   'time,vout')


%     Subsystem  ['Auto-Scale',13,'Graph'].

new_system([sys,'/',['Auto-Scale',13,'Graph']])
set_param([sys,'/',['Auto-Scale',13,'Graph']],'Location',[0,59,274,252])

add_block('built-in/Inport',[sys,'/',['Auto-Scale',13,'Graph/x']])
set_param([sys,'/',['Auto-Scale',13,'Graph/x']],...
		'position',[65,55,85,75])

add_block('built-in/S-Function',[sys,'/',['Auto-Scale',13,'Graph/S-function',13,'M-file which plots',13,'lines',13,'']])
set_param([sys,'/',['Auto-Scale',13,'Graph/S-function',13,'M-file which plots',13,'lines',13,'']],...
		'function name','sfunyst',...
		'parameters','ax, color, npts, dt',...
		'position',[130,55,180,75])
add_line([sys,'/',['Auto-Scale',13,'Graph']],[90,65;125,65])
set_param([sys,'/',['Auto-Scale',13,'Graph']],...
		'Mask Display','plot(0,0,100,100,[83,76,63,52,42,38,28,16,11,84,11,11,11,90,90,11],[75,58,47,54,72,80,84,74,65,65,65,90,40,40,90,90])',...
		'Mask Type','Storage scope.')
set_param([sys,'/',['Auto-Scale',13,'Graph']],...
		'Mask Dialogue','Storage scope using MATLAB graph window.\nEnter plotting ranges and line type.|Initial Time Range:|Initial y-min:|Initial y-max:|Storage pts.:|Line type (rgbw-.:xo):')
set_param([sys,'/',['Auto-Scale',13,'Graph']],...
		'Mask Translate','npts = @4; color = @5; ax = [0, @1, @2, @3]; dt=-1;')
set_param([sys,'/',['Auto-Scale',13,'Graph']],...
		'Mask Help','This block uses a MATLAB figure window to plot the input signal.  The graph limits are automatically scaled to the min and max values of the signal stored in the scope''s signal buffer.  Line type must be in quotes.  See the M-file sfunyst.m.')
set_param([sys,'/',['Auto-Scale',13,'Graph']],...
		'Mask Entries','5\/-10\/10\/200\/''y-/g--/c-./w:/m*/ro/b+''\/')


%     Finished composite block ['Auto-Scale',13,'Graph'].

set_param([sys,'/',['Auto-Scale',13,'Graph']],...
		'position',[365,80,395,120])

add_block('built-in/Signal Generator',[sys,'/',['Signal',13,'Generator']])
set_param([sys,'/',['Signal',13,'Generator']],...
		'Peak','1.000000',...
		'Peak Range','2.000000',...
		'Freq','100.000000',...
		'Freq Range','200.000000',...
		'Wave','Sqr',...
		'Units','Rads',...
		'position',[110,83,155,117])


%     Subsystem  ['Auto-Scale',13,'Graph1'].

new_system([sys,'/',['Auto-Scale',13,'Graph1']])
set_param([sys,'/',['Auto-Scale',13,'Graph1']],'Location',[0,59,274,252])

add_block('built-in/Inport',[sys,'/',['Auto-Scale',13,'Graph1/x']])
set_param([sys,'/',['Auto-Scale',13,'Graph1/x']],...
		'position',[65,55,85,75])

add_block('built-in/S-Function',[sys,'/',['Auto-Scale',13,'Graph1/S-function',13,'M-file which plots',13,'lines',13,'']])
set_param([sys,'/',['Auto-Scale',13,'Graph1/S-function',13,'M-file which plots',13,'lines',13,'']],...
		'function name','sfunyst',...
		'parameters','ax, color, npts, dt',...
		'position',[130,55,180,75])
add_line([sys,'/',['Auto-Scale',13,'Graph1']],[90,65;125,65])
set_param([sys,'/',['Auto-Scale',13,'Graph1']],...
		'Mask Display','plot(0,0,100,100,[83,76,63,52,42,38,28,16,11,84,11,11,11,90,90,11],[75,58,47,54,72,80,84,74,65,65,65,90,40,40,90,90])',...
		'Mask Type','Storage scope.')
set_param([sys,'/',['Auto-Scale',13,'Graph1']],...
		'Mask Dialogue','Storage scope using MATLAB graph window.\nEnter plotting ranges and line type.|Initial Time Range:|Initial y-min:|Initial y-max:|Storage pts.:|Line type (rgbw-.:xo):')
set_param([sys,'/',['Auto-Scale',13,'Graph1']],...
		'Mask Translate','npts = @4; color = @5; ax = [0, @1, @2, @3]; dt=-1;')
set_param([sys,'/',['Auto-Scale',13,'Graph1']],...
		'Mask Help','This block uses a MATLAB figure window to plot the input signal.  The graph limits are automatically scaled to the min and max values of the signal stored in the scope''s signal buffer.  Line type must be in quotes.  See the M-file sfunyst.m.')
set_param([sys,'/',['Auto-Scale',13,'Graph1']],...
		'Mask Entries','5\/-10\/10\/200\/''y-/g--/c-./w:/m*/ro/b+''\/')


%     Finished composite block ['Auto-Scale',13,'Graph1'].

set_param([sys,'/',['Auto-Scale',13,'Graph1']],...
		'position',[365,170,395,210])

add_block('built-in/Zero-Pole',[sys,'/',['Analog Butterworth',13,'LP Filter']])
set_param([sys,'/',['Analog Butterworth',13,'LP Filter']],...
		'Zeros','z',...
		'Poles','p',...
		'Gain','k',...
		'Mask Display','plot(20*log10(w),20*log10(abs(h)))',...
		'Mask Type','buttap')
set_param([sys,'/',['Analog Butterworth',13,'LP Filter']],...
		'Mask Dialogue','Analog Butterworth low pass filter.\n\n(Requires Signal Processing Toolbox)|Cutoff frequency (rad/sec)|Order')
set_param([sys,'/',['Analog Butterworth',13,'LP Filter']],...
		'Mask Translate','[z,p,k]=buttap(@2); z=@1*z; p=@1*p; k=real(prod(-p)); [num,den]=zp2tf(z,p,k); w=logspace(log10(@1/10),log10(10*@1),20); h=freqs(num,den,w); ')
set_param([sys,'/',['Analog Butterworth',13,'LP Filter']],...
		'Mask Help','Butterworth low pass filter using MATLAB''s butter command.',...
		'Mask Entries','200\/4\/',...
		'position',[230,78,290,122])

add_block('built-in/To File',[sys,'/','To File1'])
set_param([sys,'/','To File1'],...
		'File name','Vin.mat',...
		'Matrix name','vin',...
		'position',[190,20,265,50])

add_block('built-in/To File',[sys,'/','To File'])
set_param([sys,'/','To File'],...
		'File name','Vout.mat',...
		'Matrix name','vout',...
		'position',[340,20,415,50])
add_line(sys,[160,100;225,100])
add_line(sys,[295,100;360,100])
add_line(sys,[295,100;310,100;310,35;335,35])
add_line(sys,[160,100;165,100;165,35;185,35])
add_line(sys,[160,100;185,100;185,190;360,190])

drawnow

% Return any arguments.
if (nargin | nargout)
	% Must use feval here to access system in memory
	if (nargin > 3)
		if (flag == 0)
			eval(['[ret,x0,str,ts,xts]=',sys,'(t,x,u,flag);'])
		else
			eval(['ret =', sys,'(t,x,u,flag);'])
		end
	else
		[ret,x0,str,ts,xts] = feval(sys);
	end
else
	drawnow % Flash up the model and execute load callback
end
