
    % This MATLAB program generates a Chebyschev filter 
    % of specified type and order.  The magnitude frequency 
    % response is displayed.

    typ=input...
         ('Specify the type of Chebyschev filter < 1 or 2 > ')
    N=input...
         ('Specify the order of the filter:')
     % (For a type 1 filter the passband ripple should be a 
     % positive value < 1.  For a type 2 filter, the stopband ripple is 
     % entered as a positive value that represents a negative dB level. 
     % e.g. 40 dB indicates -40 dB)
    R=input...
         ('Specify the passband/stop band ripple (dB). ')

    if typ == 1,
         [z,p,k] = cheb1ap(N,R),pause
              elseif typ == 2,
              [z,p,k] = cheb2ap(N,R),pause
              R = -R
    else
         error...
              ('You must specify the filter type <1 or 2>.'),
    end
    z_p_k='The zeros, poles and multiplying constant.'

    num_den='The numerator and denominator coefficients.'
    [num,den]=zp2tf(z,p,k),pause

    [mag,phase,w] = bode(num,den);

    plot(w,mag)
    title(['Magnitude Bode plot of Chebyschev type ',...
         num2str(typ),' order ',num2str(N),' with ',...
         num2str(R),'dB ripple.'])
    xlabel('omega')
    ylabel('Magnitude')
