/*
 * Decompiled with CFR 0.152.
 */
package matsubara.gear;

import java.awt.Color;
import java.awt.Graphics;
import matsubara.gear.EPlanetaryGear;
import matsubara.gear.Gear;
import matsubara.gear.GearBase;
import matsubara.gear.PlanetaryCarrier;
import matsubara.gear.RingGear;

public class PlanetaryGear
extends GearBase {
    Gear m_ringGear;
    PlanetaryCarrier m_plaCarrier;
    Gear m_sunGear;
    Gear[] mx_piniGear;
    double m_rRingGearSpeed = 0.0;
    double m_rPlaCarrierSpeed = 0.0;

    public PlanetaryGear(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws EPlanetaryGear {
        double d = (n6 - n4) / 2 * n3 / n6;
        double d2 = (double)(n4 * n3 / n6) + d;
        this.mx_piniGear = new Gear[n8];
        this.gearCheck(n4, n6, d, n8, n7, d2);
        this.m_ringGear = new RingGear(n, n2, n6 * n3 / n6, n6, n7);
        this.m_sunGear = new Gear(n, n2, n4 * n3 / n6, n4, n7);
        this.m_plaCarrier = new PlanetaryCarrier(n, n2, (int)d2);
        int n9 = 0;
        while (n9 < this.mx_piniGear.length) {
            this.mx_piniGear[n9] = new Gear(0, 0, d, n5, n7);
            this.mx_piniGear[n9].setColor1(Color.orange);
            this.mx_piniGear[n9].setColor2(Color.darkGray);
            this.mx_piniGear[n9].setAngle(Math.PI * 2 * (double)n9 / (double)this.mx_piniGear.length + Math.PI * 2 / (double)this.mx_piniGear[n9].getGearCount() / 2.0 - Math.PI * 2 / (double)this.mx_piniGear[n9].getGearCount() * (double)(this.m_ringGear.getGearCount() % n8) * (double)n9 / (double)n8);
            ++n9;
        }
        this.move(0.0);
        this.m_plaCarrier.setColor2(Color.red);
        this.m_sunGear.setColor2(Color.blue);
        this.m_ringGear.setColor2(new Color(0, 187, 0));
        this.m_plaCarrier.setWidth((int)this.mx_piniGear[0].getSize());
        if (n5 % 2 == 1) {
            this.m_sunGear.setAngle(Math.PI * 2 / (double)(this.m_sunGear.getGearCount() * 2));
        }
    }

    public void gearCheck(int n, int n2, double d, int n3, int n4, double d2) throws EPlanetaryGear {
        if (d * 2.0 + (double)n4 >= 2.0 * d2 * Math.sin(Math.PI / (double)n3)) {
            throw new EPlanetaryGear("\u30d4\u30cb\u30aa\u30f3\u30ae\u30a2\u540c\u58eb\u304c\u3076\u3064\u304b\u308a\u5408\u3044\u307e\u3059\u3002");
        }
        if ((n2 + n) % n3 != 0) {
            throw new EPlanetaryGear("\u6b6f\u8eca\u304c\u304b\u307f\u5408\u3044\u307e\u305b\u3093\u3002");
        }
        if (n2 <= n) {
            throw new EPlanetaryGear("\u30ea\u30f3\u30b0\u30ae\u30a2\u306f\u30b5\u30f3\u30ae\u30a2\u3088\u308a\u5927\u304d\u304f\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public void draw(Graphics graphics) {
        this.m_ringGear.draw(graphics);
        this.m_plaCarrier.draw(graphics);
        this.m_sunGear.draw(graphics);
        int n = 0;
        while (n < this.mx_piniGear.length) {
            this.mx_piniGear[n].draw(graphics);
            ++n;
        }
    }

    public void move(double d) {
        int n = this.m_ringGear.getGearCount();
        int n2 = this.m_sunGear.getGearCount();
        double d2 = (this.m_sunGear.getSize() + this.m_ringGear.getSize()) / 2.0;
        double d3 = (this.m_rPlaCarrierSpeed * (double)(n + n2) - this.m_rRingGearSpeed * (double)n) / (double)n2;
        this.m_sunGear.setAngle(this.m_sunGear.getAngle() + d3 / 60.0 / 1000.0 * d * 2.0 * Math.PI);
        this.m_plaCarrier.setAngle(this.m_plaCarrier.getAngle() + this.m_rPlaCarrierSpeed / 60.0 / 1000.0 * d * 2.0 * Math.PI);
        this.m_ringGear.setAngle(this.m_ringGear.getAngle() + this.m_rRingGearSpeed / 60.0 / 1000.0 * d * 2.0 * Math.PI);
        double d4 = this.m_rPlaCarrierSpeed + (this.m_rRingGearSpeed - this.m_rPlaCarrierSpeed) * (double)this.m_ringGear.getGearCount() / (double)this.mx_piniGear[0].getGearCount();
        int n3 = 0;
        while (n3 < this.mx_piniGear.length) {
            this.mx_piniGear[n3].setPosX(this.m_plaCarrier.rotateX(d2, Math.PI * 2 * (double)n3 / (double)this.mx_piniGear.length));
            this.mx_piniGear[n3].setPosY(this.m_plaCarrier.rotateY(d2, Math.PI * 2 * (double)n3 / (double)this.mx_piniGear.length));
            this.mx_piniGear[n3].setAngle(this.mx_piniGear[n3].getAngle() + d4 / 60.0 / 1000.0 * d * 2.0 * Math.PI);
            ++n3;
        }
    }

    public void setRingGearSpeed(double d) {
        this.m_rRingGearSpeed = d;
    }

    public double getRingGearSpeed() {
        return this.m_rRingGearSpeed;
    }

    public void setPlaCarrierSpeed(double d) {
        this.m_rPlaCarrierSpeed = d;
    }

    public double getPlaCarrierSpeed() {
        return this.m_rPlaCarrierSpeed;
    }

    public double getSunGearSpeed() {
        double d = this.m_ringGear.getGearCount();
        double d2 = this.m_sunGear.getGearCount();
        return (this.m_rPlaCarrierSpeed * (d + d2) - this.m_rRingGearSpeed * d) / d2;
    }

    public void setSunGearSpeed(double d) {
        double d2 = this.m_ringGear.getGearCount();
        double d3 = this.m_sunGear.getGearCount();
        this.setPlaCarrierSpeed((int)((d * d3 + this.m_rRingGearSpeed * d2) / (d2 + d3)));
    }

    public Gear getRingGear() {
        return this.m_ringGear;
    }

    public PlanetaryCarrier getPlanetaryCarrier() {
        return this.m_plaCarrier;
    }

    public Gear getSunGear() {
        return this.m_sunGear;
    }

    public void setPosX(int n) {
        super.setPosX(n);
        this.m_ringGear.setPosX(n);
        this.m_plaCarrier.setPosX(n);
        this.m_sunGear.setPosX(n);
        this.move(0.0);
    }

    public void setPosY(int n) {
        super.setPosY(n);
        this.m_ringGear.setPosY(n);
        this.m_plaCarrier.setPosY(n);
        this.m_sunGear.setPosY(n);
        this.move(0.0);
    }

    public void setSize(double d) {
        super.setSize(d);
        this.m_ringGear.setSize(d);
        this.m_sunGear.setSize(d * (double)this.m_sunGear.getGearCount() / (double)this.m_ringGear.getGearCount());
        int n = 0;
        while (n < this.mx_piniGear.length) {
            this.mx_piniGear[n].setSize((this.m_ringGear.getSize() - this.m_sunGear.getSize()) / 2.0);
            ++n;
        }
        this.m_plaCarrier.setWidth((int)(this.m_ringGear.getSize() - this.m_sunGear.getSize()) / 2);
        this.m_plaCarrier.setSize(this.m_sunGear.getSize() * d / this.m_ringGear.getSize() + this.mx_piniGear[0].getSize());
        this.move(0.0);
    }
}

