/*
 * Decompiled with CFR 0.152.
 */
package matsubara.uiext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import matsubara.uiext.event.ChangeEvent;
import matsubara.uiext.event.ChangeListener;

public class Slider
extends Component {
    transient Vector m_listeners = new Vector();
    int m_nMinimum = 0;
    int m_nMaximum = 100;
    int m_nValue = 0;
    int m_nMajorTickSpacing = 10;
    int m_nMinorTickSpacing = 2;
    int m_nVisibleAmount = 10;
    boolean m_bPrintLabel = false;
    Dimension m_minimumSize;
    Dimension m_preferredSize;
    transient int m_nCharHeight = 0;
    transient int m_nMoveRange = 0;
    transient boolean m_bSlide = false;
    transient int m_nSliderPos = 0;
    transient int m_nMousePos = 0;

    public Slider() {
        this.enableEvents(501L);
        this.enableEvents(502L);
        this.enableEvents(506L);
        this.m_minimumSize = new Dimension(30, 120);
        this.m_preferredSize = new Dimension(70, 220);
        this.setBounds(0, 0, this.m_preferredSize.width, this.m_preferredSize.height);
    }

    public Dimension minimumSize() {
        return this.m_minimumSize;
    }

    public Dimension getMinimumSize() {
        return this.m_minimumSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.m_minimumSize = dimension;
    }

    public Dimension preferredSize() {
        return this.m_preferredSize;
    }

    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.m_preferredSize = dimension;
    }

    public void paint(Graphics graphics) {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        graphics.setFont(this.getFont());
        this.m_nCharHeight = graphics.getFontMetrics().getHeight();
        this.m_nMoveRange = n2 - this.m_nCharHeight;
        int n3 = this.m_nValue;
        int n4 = this.valueToPos(n3);
        graphics.setColor(Color.gray);
        graphics.drawRect(10, this.m_nCharHeight / 2 - 2, 4, this.m_nMoveRange + 4);
        if (this.isEnabled()) {
            graphics.setColor(Color.darkGray);
            graphics.drawRect(9, this.m_nCharHeight / 2 - 3, 5, this.m_nMoveRange + 5);
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(3, n4 - (this.m_nVisibleAmount / 2 - 1), 18, this.m_nVisibleAmount);
        if (this.isEnabled()) {
            graphics.setColor(Color.white);
            graphics.drawLine(3, n4 - this.m_nVisibleAmount / 2, 20, n4 - this.m_nVisibleAmount / 2);
            graphics.drawLine(2, n4 - (this.m_nVisibleAmount / 2 - 1), 2, n4 + (this.m_nVisibleAmount / 2 - 1));
            graphics.drawLine(4, n4 + 1, 19, n4 + 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(3, n4 + this.m_nVisibleAmount / 2, 20, n4 + this.m_nVisibleAmount / 2);
            graphics.drawLine(21, n4 - (this.m_nVisibleAmount / 2 - 1), 21, n4 + (this.m_nVisibleAmount / 2 - 1));
            graphics.drawLine(4, n4 - 1, 19, n4 - 1);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(3, n4 - this.m_nVisibleAmount / 2, 20, n4 - this.m_nVisibleAmount / 2);
            graphics.drawLine(2, n4 - (this.m_nVisibleAmount / 2 - 1), 2, n4 + (this.m_nVisibleAmount / 2 - 1));
            graphics.drawLine(3, n4 + this.m_nVisibleAmount / 2, 20, n4 + this.m_nVisibleAmount / 2);
            graphics.drawLine(21, n4 - (this.m_nVisibleAmount / 2 - 1), 21, n4 + (this.m_nVisibleAmount / 2 - 1));
            graphics.drawLine(4, n4, 19, n4);
        }
        if (this.m_bPrintLabel) {
            int n5;
            int n6;
            graphics.setColor(this.getForeground());
            if (this.m_nMinorTickSpacing > 0) {
                n6 = this.m_nMinimum;
                while (n6 <= this.m_nMaximum) {
                    n5 = this.m_nCharHeight / 2 + this.m_nMoveRange - this.m_nMoveRange * (n6 - this.m_nMinimum) / (this.m_nMaximum - this.m_nMinimum);
                    graphics.drawLine(24, n5, 27, n5);
                    n6 += this.m_nMinorTickSpacing;
                }
            }
            if (this.m_nMajorTickSpacing > 0) {
                n6 = this.m_nMinimum;
                while (n6 <= this.m_nMaximum) {
                    n5 = this.m_nCharHeight / 2 + this.m_nMoveRange - this.m_nMoveRange * (n6 - this.m_nMinimum) / (this.m_nMaximum - this.m_nMinimum);
                    graphics.drawLine(24, n5, 30, n5);
                    graphics.drawString(String.valueOf(n6), 32, n5 + this.m_nCharHeight / 2);
                    n6 += this.m_nMajorTickSpacing;
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public int valueToPos(int n) {
        return this.m_nCharHeight / 2 + this.m_nMoveRange - this.m_nMoveRange * (n - this.m_nMinimum) / (this.m_nMaximum - this.m_nMinimum);
    }

    public int posToValue(int n) {
        return this.m_nMinimum + (this.m_nCharHeight / 2 + this.m_nMoveRange - n) * (this.m_nMaximum - this.m_nMinimum) / this.m_nMoveRange;
    }

    public void setValue(int n) {
        if (n < this.m_nMinimum) {
            n = this.m_nMinimum;
        }
        if (n > this.m_nMaximum) {
            n = this.m_nMaximum;
        }
        if (this.m_nValue != n) {
            this.m_nValue = n;
            ChangeEvent changeEvent = new ChangeEvent(this);
            int n2 = this.m_listeners.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_listeners.elementAt(n3) instanceof ChangeListener) {
                    ((ChangeListener)this.m_listeners.elementAt(n3)).stateChanged(changeEvent);
                }
                ++n3;
            }
            Graphics graphics = this.getParent().getGraphics();
            if (graphics != null) {
                Rectangle rectangle = this.getBounds();
                Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2.clearRect(0, 0, 28, rectangle.height);
                this.paint(graphics2);
            }
        }
    }

    public int getValue() {
        return this.m_nValue;
    }

    public void setMaximum(int n) {
        if (n > this.getMinimum()) {
            this.m_nMaximum = n;
            this.setValue(this.getValue());
        }
    }

    public int getMaximum() {
        return this.m_nMaximum;
    }

    public void setMinimum(int n) {
        if (n < this.getMaximum()) {
            this.m_nMinimum = n;
            this.setValue(this.getValue());
        }
    }

    public int getMinimum() {
        return this.m_nMinimum;
    }

    public void setMajorTickSpacing(int n) {
        this.m_nMajorTickSpacing = n;
    }

    public int getMajorTickSpacing() {
        return this.m_nMajorTickSpacing;
    }

    public void setMinorTickSpacing(int n) {
        this.m_nMinorTickSpacing = n;
    }

    public int getMinorTickSpacing() {
        return this.m_nMinorTickSpacing;
    }

    public void setVisibleAmount(int n) {
        if (n > 0) {
            this.m_nVisibleAmount = n;
        }
    }

    public int getVisibleAmount() {
        return this.m_nVisibleAmount;
    }

    public void setPrintLabel(boolean bl) {
        this.m_bPrintLabel = bl;
    }

    public boolean isPrintLabel() {
        return this.m_bPrintLabel;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        this.m_listeners.addElement(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.m_listeners.elementAt(n2) == changeListener) {
                this.m_listeners.remove(n2);
            }
            ++n2;
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.m_listeners.toArray();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                int n = this.m_nValue;
                if (n > this.m_nMaximum) {
                    n = this.m_nMaximum;
                }
                if (n < this.m_nMinimum) {
                    n = this.m_nMinimum;
                }
                if (!this.isEnabled() || this.valueToPos(n) - this.m_nVisibleAmount / 2 > mouseEvent.getY() || mouseEvent.getY() > this.valueToPos(n) + this.m_nVisibleAmount / 2 || 3 > mouseEvent.getX() || mouseEvent.getX() > 28) break;
                this.m_nMousePos = mouseEvent.getY();
                this.m_nSliderPos = this.valueToPos(this.m_nValue);
                this.m_bSlide = true;
                break;
            }
            case 502: {
                this.m_bSlide = false;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 506: {
                if (!this.m_bSlide) break;
                int n = this.posToValue(this.m_nSliderPos + mouseEvent.getY() - this.m_nMousePos);
                if (n > this.m_nMaximum) {
                    n = this.m_nMaximum;
                }
                if (n < this.m_nMinimum) {
                    n = this.m_nMinimum;
                }
                this.setValue(n);
                this.repaint(0, 0, 28, this.getBounds().height);
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }
}

