% afalbut.m  GENERATE BUTTONS: ALBUM OF ANALOG FILTER REALIZATIONS (script)
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

x0 = 0; y0 = 0; dx = 2; ds = 2.5; F  = 10;
pathnamea = lower(pwd);
pathnameaopamp = lower([pathnamea '\album\opamp']);
pathnameaota = lower([pathnamea '\album\ota']);
pathnameacc = lower([pathnamea '\album\cc']);
pathnamearlc = lower([pathnamea '\album\rlc']);
pathnameadrawdraw = lower([pathnamea '\album\utility']);

uiLPLQ = uicontrol('String', 'LPLQ', 'Units', 'normalized' ...
  , 'Position', [0.0 0.90 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawlplq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiLPMQ = uicontrol('String', 'LPMQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.84 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawlpmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiLPHQ = uicontrol('String', 'LPHQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.78 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawlphq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiLPNMQ = uicontrol('String', 'LPNMQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.70 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawlnmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiLPNHQ = uicontrol('String', 'LPNHQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.64 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawlnhq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiHPLQ = uicontrol('String', 'HPLQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.56 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawhplq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiHPMQ = uicontrol('String', 'HPMQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.50 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawhpmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiHPHQ = uicontrol('String', 'HPHQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.44 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawhphq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiHPNMQ = uicontrol('String', 'HPNMQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.36 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawhnmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiHPNHQ = uicontrol('String', 'HPNHQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.30 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawhnhq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiAPLQ = uicontrol('String', 'APLQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.22 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawaplq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiAPMQ = uicontrol('String', 'APMQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.16 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawapmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiAPHQ = uicontrol('String', 'APHQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.10 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawaphq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiBPLQ = uicontrol('String', 'BPLQ', 'Units', 'normalized' ...
     , 'Position', [0.0 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawbplq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiBPMQ = uicontrol('String', 'BPMQ', 'Units', 'normalized' ...
     , 'Position', [0.085 0.01 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawbpmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiBPHQ = uicontrol('String', 'BPHQ', 'Units', 'normalized' ...
     , 'Position', [0.18 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawbphq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiBRLQ = uicontrol('String', 'BRLQ', 'Units', 'normalized' ...
     , 'Position', [0.275 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawbrlq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiBPMQ = uicontrol('String', 'BRMQ', 'Units', 'normalized' ...
     , 'Position', [0.36 0.01 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawbrmq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiBPHQ = uicontrol('String', 'BRHQ', 'Units', 'normalized' ...
     , 'Position', [0.455 0.01 0.09 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawbrhq(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiOTA1 = uicontrol('String', 'OTA1', 'Units', 'normalized' ...
     , 'Position', [0.58 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaota);clf;eval(''drawotab(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiOTA2 = uicontrol('String', 'OTA2', 'Units', 'normalized' ...
     , 'Position', [0.665 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaota);clf;eval(''drawotac(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiOTA3 = uicontrol('String', 'OTA3', 'Units', 'normalized' ...
     , 'Position', [0.75 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaota);clf;eval(''drawotad(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiOTA4 = uicontrol('String', 'OTA4', 'Units', 'normalized' ...
     , 'Position', [0.835 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaota);clf;eval(''drawotae(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiOTA5 = uicontrol('String', 'OTA5', 'Units', 'normalized' ...
     , 'Position', [0.92 0.01 0.08 0.05], 'CallBack', ...
  'cd(pathnameaota);clf;eval(''drawotaf(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiRLC4  = uicontrol('String', 'RLC4', 'Units', 'normalized' ...
     , 'Position', [0.92 0.09 0.08 0.05], 'CallBack', ...
  'cd(pathnamearlc);clf;eval(''drawlc4(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiRLC3  = uicontrol('String', 'RLC3', 'Units', 'normalized' ...
     , 'Position', [0.92 0.15 0.08 0.05], 'CallBack', ...
  'cd(pathnamearlc);clf;eval(''drawlc3(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiRLC2  = uicontrol('String', 'RLC2', 'Units', 'normalized' ...
     , 'Position', [0.92 0.21 0.08 0.05], 'CallBack', ...
  'cd(pathnamearlc);clf;eval(''drawlc2(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiRLC1  = uicontrol('String', 'RLC1', 'Units', 'normalized' ...
     , 'Position', [0.92 0.27 0.08 0.05], 'CallBack', ...
  'cd(pathnamearlc);clf;eval(''drawlc1(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiCCSK = uicontrol('String', 'CCSK', 'Units', 'normalized' ...
     , 'Position', [0.92 0.37 0.08 0.05], 'CallBack', ...
  'cd(pathnameacc);clf;eval(''drawccsk(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiSK2B = uicontrol('String', 'SK2B', 'Units', 'normalized' ...
     , 'Position', [0.92 0.43 0.08 0.05], 'CallBack', ...
  'cd(pathnameadrawdraw);clf;eval(''drawsk2b''); cd ..; cd ..; afalbut');

uiKHN = uicontrol('String', 'KHN', 'Units', 'normalized' ...
     , 'Position', [0.92 0.49 0.08 0.05], 'CallBack', ...
  'cd(pathnameaopamp);clf;eval(''drawkhn(x0,x0,dx,ds,F)''); cd ..; cd ..; afalbut');

uiCLOSE = uicontrol('String', 'close', 'Units', 'normalized' ...
     , 'Position', [0.92 0.92 0.07 0.06] ...
     , 'CallBack', 'close(gcf)');

uiINFO = uicontrol('String', 'info', 'Units', 'normalized' ...
     , 'Position', [0.92 0.82 0.07 0.06] ...
     , 'CallBack', 'afalbum');

