function dr = drawskoa(x0 ,y0 ,dx ,ds ,F , dc, R)
   
% drawskoa.m  DRAW BIQUAD SALLEN-KEY (for drawsk2b.m)
%   
%      DrawFilt version 2.5  ---  Drawing Filter Realizations      
%            Album of Analog Filter Realizations
%                                                               
%   Authors: Miroslav D. Lutovac, Dejan V. Tosic    
%   Email: lutovac@iritel.bg.ac.yu      http://galeb.etf.bg.ac.yu/~lutovac/
%   Email: tosic@galeb.etf.bg.ac.yu     http://www.rcub.bg.ac.yu/~tosicde/
%   Copyright (c) 1999-2001 by Lutovac & Tosic                     
%   $Revision: 2.01 $  $Date: 2001/12/24$                    
%                                                                
%   References:
%   [1] Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans          
%       Filter Design for Signal Processing                     
%       Using MATLAB and Mathematica                         
%       Prentice Hall - ISBN 0-201-36130-2                      
%       http://www.prenhall.com/lutovac                        
%   [2] G. S. Moschytz, P. Horn
%       Active Filter Design Handbook
%       John Wiley, New York, 1981
%                                                                
% call    drawskoa( 0,0,4,5,8,'b',['1','2','1','2','1','2','3','4']');
% call    drawskoa
%                                                                
      
narginmydraw = nargin;
if narginmydraw ~= 7
   x0 = 0;
   y0 = 0;
   dx = 4;
   ds = 5;
   F  = 8;
   dc = 'b';
   R  = ['1','2','1','2','1','2','3','4'];
end       
Nx = 100;    Ny = 100;   whitebg(figure(gcf),[1 1 1]);
if exist('dc') == 0
  dc = 'k';
end
if exist('dc') == 0
  R = ['1','2','1','2','1','2','3','4']';
end
x = (1:4*Nx)*dx/4 + x0; y = (1:4*Ny)*dx/4 + y0;
   
% drawtext(x(6), y(9), 'Sallen-Key biquad',F+1,dc)
drawopam(x(11), y(5), x(15), ' ', ['A_' R(5)], 0, ds, F, dc);
drawres(x(2), y(6), x(6), ' ', ['R_' R(1)], 0, ds/2, F, dc);
drawres(x(6), y(6), x(10), ' ', ['R_' R(2)],  0, ds/2, F, dc);
drawcap(x(10), y(2), y(6), ' ', ['C_' R(4)],  1, ds/2, F, dc);
drawcap(x(6), y(8), x(15), ' ', ['C_' R(3)],  0, ds/2, F, dc);
drawnode(x(6), y(6), ['V_' R(6)], 6, 1, F, dc);
drawnode(x(10), y(6), ['V_' R(7)], 2, 1, F, dc);
drawnode(x(15), y(5), ['V_' R(8)], 7, 1, F, dc);
drawgrnd(x(10), y(2), 0, ds/2, dc);
drawlhv(x(11), y(4), x(15), y(2), 1, dc);
drawlhv(x(10), y(6), x(11), y(6), 0, dc);
drawlhv(x(6), y(6), x(6), y(8), 0, dc);
drawlhv(x(15), y(5), x(15), y(8), 0, dc);
drawlhv(x(15), y(5), x(15), y(2), 0, dc);
axis('equal')
axis('off')
