function matrixEn = bdrwmath(matrixE,myfilename,mypathname)
% bdrwmath.m    BUTTON: EXPORT TO MATHEMATICA
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2

mypathnamema = lower(mypathname);
lrmypathnamema= fliplr(mypathnamema);
if lrmypathnamema(1) == '\';
  mypathnamema(length(mypathnamema)) = [];
end

clc
[s1,s2] = size(matrixE);

if s1 > 1

title('MATLAB -> Mathematica')

disp(' ')

a3 = ' ';  a5 = ' ';

for indEp = 1:s1-1

indE = indEp+1;

if (indE>1)&(indE<s1+1)

t1 = matrixE(indE,:);
i1 = find(t1-','==0);

msi1 =  max(size(i1));
msi2 =  max(size(t1));

if     msi1 > 0
  a01 = t1(1:i1(1)-1);
  msi3 =  max(size(a01));
  ii1 = find(a01-'('==0);
  msi4 =  max(size(ii1));
  if     msi4 > 0
    a0 = t1(1 : ii1(1)-1);
    a1 = t1(ii1(1)+1 : msi3);
    a1(length(a1))=[]; a1(1:2)=[]; a1=['x[[' a1 ']]'];
  end
  newa = ' ';
  newa = [];
  if     msi4 > 0
% ###################################### change name
    a0M = a0;
    if length(a0)==6
      a0(7)= ' ';
    end
    if sum(abs(a0(1:7) - 'drawin ')) == 0
      a0M(1:6) = 'DrawIn';
      a0M(7) = ' ';
      a0M(7) = [];
    end
    if sum(abs(a0(1:7) - 'drawadd')) == 0
      a0M(1:7) = 'DrawAdd';
    end
    if sum(abs(a0(1:7) - 'drawblo')) == 0
      a0M(1:7) = 'DrawBlo';
    end
    if sum(abs(a0(1:7) - 'drawcap')) == 0
      a0M(1:7) = 'DrawCap';
    end
    if sum(abs(a0(1:7) - 'drawcc ')) == 0
      a0M(1:6) = 'DrawCC';
    end
    if sum(abs(a0(1:7) - 'drawccs')) == 0
      a0M(1:7) = 'DrawCCS';
    end
    if sum(abs(a0(1:7) - 'drawcs ')) == 0
      a0M(1:6) = 'DrawCS';
    end
    if sum(abs(a0(1:7) - 'drawcvs')) == 0
      a0M(1:7) = 'DrawCVS';
    end
    if sum(abs(a0(1:7) - 'drawdel')) == 0
      a0M(1:7) = 'DrawDel';
    end
    if sum(abs(a0(1:7) - 'drawimp')) == 0
      a0M(1:7) = 'DrawImp';
    end
    if sum(abs(a0(1:7) - 'drawlhv')) == 0
      a0M(1:7) = 'DrawLHV';
    end
    if sum(abs(a0(1:7) - 'drawlnd')) == 0
      a0M(1:7) = 'DrawLnd';
    end
    if sum(abs(a0(1:7) - 'drawlvh')) == 0
      a0M(1:7) = 'DrawLVH';
    end
    if sum(abs(a0(1:7) - 'drawota')) == 0
      a0M(1:7) = 'DrawOTA';
    end
    if sum(abs(a0(1:7) - 'drawout')) == 0
      a0M(1:7) = 'DrawOut';
    end
    if sum(abs(a0(1:7) - 'drawres')) == 0
      a0M(1:7) = 'DrawRes';
    end
    if sum(abs(a0(1:7) - 'drawvs ')) == 0
      a0M(1:6) = 'DrawVS';
    end

    if length(a0)==8
      if sum(abs(a0(1:8) - 'drawarrw')) == 0
        a0M(1:8) = 'DrawArrw';
      end
      if sum(abs(a0(1:8) - 'drawline')) == 0
        a0M(1:8) = 'DrawLine';
      end
      if sum(abs(a0(1:8) - 'drawgrnd')) == 0
        a0M(1:8) = 'DrawGrnd';
      end
      if sum(abs(a0(1:8) - 'drawmult')) == 0
        a0M(1:8) = 'DrawMult';
      end
      if sum(abs(a0(1:8) - 'drawnode')) == 0
        a0M(1:8) = 'DrawNode';
      end
      if sum(abs(a0(1:8) - 'drawopam')) == 0
        a0M(1:8) = 'DrawOpAm';
      end
      if sum(abs(a0(1:8) - 'draw4tbl')) == 0
        a0M(1:8) = 'Draw4TBL';
      end
      if sum(abs(a0(1:8) - 'drawtext')) == 0
        a0M(1:8) = 'DrawText';
      end
      if sum(abs(a0(1:8) - 'drawupsa')) == 0
        a0M(1:8) = 'DrawUpSa';
      end
      if sum(abs(a0(1:8) - 'drawdown')) == 0
        a0M(1:8) = 'DrawDown';
      end
    end

    newa = [a0M '[' a1];
  end
  if msi1 > 1
    a2 = t1(i1(1)+1:i1(2)-1);
    abi=0;abi=[];abi = find(a2-' '==0); 
    if isempty(abi) == 0
      for ind = length(abi):-1:1
        a2(abi(ind)) =[];
      end
    end
    a2(length(a2))=[]; a2(1:2)=[]; a2=['y[[' a2 ']]'];
    if msi1 > 2
      a3 = t1(i1(2)+1:i1(3)-1);
      abi=0;abi=[];abi = find(a3-' '==0); 
      if isempty(abi) == 0
        for ind = length(abi):-1:1
          a3(abi(ind)) =[];
        end
      end

if a3(1)=='y'
    a3(length(a3))=[]; a3(1:2)=[]; a3=['y[[' a3 ']]'];
elseif a3(1)=='x'
    a3(length(a3))=[]; a3(1:2)=[]; a3=['x[[' a3 ']]'];
elseif (sum(abs(a0(1:7)-'drawnod'))==0)|...
  (sum(abs(a0(1:7)-'drawin '))==0)|...
  (sum(abs(a0(1:7)-'drawarr'))==0)|...
  (sum(abs(a0(1:7)-'drawout'))==0|sum(abs(a0(1:7)-'drawtex'))== 0)
  a3(1) = []; a3(length(a3)) = [];
  a3 = ['"' a3 ' "'];
end

        if msi1 > 3
          a4 = t1(i1(3)+1:i1(4)-1);
          abi=0;abi=[];abi = find(a4-' '==0); 
          if isempty(abi) == 0
            for ind = length(abi):-1:1
              a4(abi(ind)) =[];
            end
          end
    if (sum(abs(a0(1:7)-'drawgrn'))==0)
      a4 = a4;
    elseif sum(abs(a0(1:7) - 'drawadd')) > 0
      if a4(1)=='y'
          a4(length(a4))=[]; a4(1:2)=[]; a4=['y[[' a4 ']]'];
      elseif a4(1)=='x'
          a4(length(a4))=[]; a4(1:2)=[]; a4=['x[[' a4 ']]'];
      elseif (sum(abs(a0(1:7)-'drawnod'))>0)&...
        (sum(abs(a0(1:7)-'drawin ')) >0)&... 
        (sum(abs(a0(1:7)-'drawarr')) >0)&...
        (sum(abs(a0(1:7)-'drawout')) > 0)&...
        (sum(abs(a0(1:7)-'drawtex')) > 0)
         a4(1)='"'; a4(length(a4))=' ';  a4(length(a4)+1)='"'; 
    end
  end
          if msi1 > 4
            a5 = t1(i1(4)+1:i1(5)-1);
            abi=0;abi=[];abi = find(a5-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                a5(abi(ind)) =[];
              end
            end
          end
  a5lold = a5;
  if sum(abs(a0(1:7) - 'drawadd')) > 0
    if a5(1)=='y'
        a5(length(a5))=[]; a5(1:2)=[]; a5=['y[[' a5 ']]'];
    elseif a5(1)=='x'
        a5(length(a5))=[]; a5(1:2)=[]; a5=['x[[' a5 ']]'];
    elseif (sum(abs(a0(1:7)-'drawnod'))>0)&(sum(abs(a0(1:7)-'drawin '))>0)&...
     (sum(abs(a0(1:7)-'drawarr'))>0)&...
     (sum(abs(a0(1:7) - 'drawout')) > 0)
        a5(1)='"'; a5(length(a5))=' ';  a5(length(a5)+1)='"'; 
    elseif (sum(abs(a0(1:7) - 'drawnod')) == 0)
        a5 = '1'; 
    end
  end
        end
      end
    end
  end
  
  if     msi1 > 5
    a6 = t1(i1(5)+1:i1(6)-1);
            abi=0;abi=[];abi = find(a6-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                a6(abi(ind)) =[];
              end
            end
    if msi1 > 6
      a7 = t1(i1(6)+1:i1(7)-1);
            abi=0;abi=[];abi = find(a7-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                a7(abi(ind)) =[];
              end
            end
      if msi1 > 7
        a8 = t1(i1(7)+1:i1(8)-1);
            abi=0;abi=[];abi = find(a8-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                a8(abi(ind)) =[];
              end
            end
        if msi1 > 8
          a9 = t1(i1(8)+1:i1(9)-1);
            abi=0;abi=[];abi = find(a9-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                a9(abi(ind)) =[];
              end
            end
          if msi1 > 9
            a10 = t1(i1(9)+1:i1(10)-1);
            abi=0;abi=[];abi = find(a10-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                a10(abi(ind)) =[];
              end
            end
          end
        end
      end
    end
  end
  
  aend =  t1(i1(msi1)+1:msi2);
            abi=0;abi=[];abi = find(aend-' '==0); 
            if isempty(abi) == 0
              for ind = length(abi):-1:1
                aend(abi(ind)) =[];
              end
            end

    if sum(abs(a0(1:7) - 'drawadd')) == 0
      a7(1)='"'; a7(length(a7))=' ';  a7(length(a7)+1)='"'; 
    end
  end
  
  if sum(abs(a0(1:7) - 'drawlhv')) == 0
    a5=a5lold;
  end
  if sum(abs(a0(1:7) - 'drawlvh')) == 0
    a5=a5lold;
  end
  
  if     msi1 > 0
    if msi1 > 1
      newa = [newa ',' a2];
      if msi1 > 2
        newa = [newa ',' a3];
        if msi1 > 3
          newa = [newa ',' a4];
          if msi1 > 4
            newa = [newa ',' a5];
          end
        end
      end
    end
  end
  if     msi1 > 5
    newa = [newa ',' a6];
    if msi1 > 6
      newa = [newa ',' a7];
      if msi1 > 7
        newa = [newa ',' a8];
        if msi1 > 8
          newa = [newa ',' a9];
          if msi1 > 9
            newa = [newa ',' a10];
          end
        end
      end
    end
  end
  
        newa = [newa '],'];
  
  matrixE(indE,1:61) ='                                                             ';
  matrixE(indE,1:length(newa))=newa;
  
  end
  
  matrixEn = matrixE;
                     
  myfilenamem = myfilename(1:(length(myfilename)-2));
  myfilenamemma = [myfilenamem '.mma']
  existmyfilename = exist(myfilenamemma,'file');
  
  if existmyfilename == 2
     delete(myfilenamemma);                 
  end
% make MMA file

  diary(myfilenamemma)
                   
  timedraw = clock;
  tmpstr = ['(* creation date: ' date '  time: ' num2str(timedraw(4)) ':' num2str(timedraw(5)) '*)'];
                   
  disp(' ')
  disp('(*  DrawMath                                                      ')
  disp(' Schematic generated from DrawFilt version 2.8                    ')
  disp('                                                                  ')
  disp(' Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic   ')
  disp(' lutovac@kondor.etf.bg.ac.yu  http://kondor.etf.bg.ac.yu/~lutovac/')
  disp(' tosic@galeb.etf.bg.ac.yu     http://www.rcub.bg.ac.yu/~tosicde/  ')
  disp(' Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic       ')
  disp(' $Revision: 2.8 $  $Date: 2005/03/04                              ')
  disp('                                                                  ')
  disp('   Reference:                                                     ')
  disp('   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans            ')
  disp('        Filter Design for Signal Processing                       ')
  disp('           Using MATLAB and Mathematica                           ')
  disp('        Prentice Hall    ISBN 0-201-36130-2                       ')
  disp('                                                                  ')
  disp('   call:                                                          ')
  disp(['   SetDirectory["' mypathnamema '"];                            '])
  disp('   <<drawflib.mma                                                 ')
  disp(['   <<' myfilenamemma '                                          '])
  disp('   DrawMath[0,0,1,5,9];                                        *) ')
      
  disp(tmpstr)
  disp('Nx = 100;')
  disp('Ny = 100;')
  disp('x0 = 0;')
  disp('y0 = 0;')
  disp('dx = 4;')
  disp('x = x0+Table[i*dx/4,{i,4*Nx}];')
  disp('y = y0+Table[i*dx/4,{i,4*Ny}];')
  disp('DrawMath[x0_,y0_,dx_,ds_,F_:9] := Module[{')
  disp('x = x0+Table[i*dx,{i,200}],  y = y0+Table[i*dx,{i,200}]},')
  disp('Show[{')
  disp(matrixE)
  disp('{}')
  disp('}')
  disp(',AspectRatio -> Automatic,Axes -> False, PlotRange -> All]];')
  disp(' (* DrawMath[0,0,1,5,9]; *) ')
  end
  diary  off

% make MA file

myfilenamemmamain = [myfilenamem '.ma']
existmyfilename = exist(myfilenamemmamain,'file');
if existmyfilename == 2
   delete(myfilenamemmamain);
end
diary(myfilenamemmamain)
disp('(*^')
disp(' ')
disp('::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";')
disp('	microsoftWindowsStandardFontEncoding;')
disp('	fontset = title, "Arial", 24, L0, center, nohscroll, bold;')
disp('	fontset = subtitle, "Arial", 18, L0, center, nohscroll, bold;')
disp('	fontset = subsubtitle, "Arial", 14, L0, center, nohscroll, bold;')
disp('	fontset = section, "Arial", 14, L0, bold, grayBox;')
disp('	fontset = subsection, "Arial", 12, L0, bold, blackBox;')
disp('	fontset = subsubsection, "Arial", 10, L0, bold, whiteBox;')
disp('	fontset = text, "Arial", 12, L0;')
disp('	fontset = smalltext, "Arial", 10, L0;')
disp('	fontset = input, "Courier New", 12, L0, nowordwrap, bold;')
disp('	fontset = output, "Courier New", 12, L0, nowordwrap;')
disp('	fontset = message, "Courier New", 10, L0, nowordwrap, R65280;')
disp('	fontset = print, "Courier New", 10, L0, nowordwrap;')
disp('	fontset = info, "Courier New", 10, L0, nowordwrap;')
disp('	fontset = postscript, "Courier New", 8, L0, nowordwrap;')
disp('	fontset = name, "Arial", 10, L0, nohscroll, italic, B65280;')
disp('	fontset = header, "Times New Roman", 10, L0, right, nohscroll;')
disp('	fontset = footer, "Times New Roman", 10, L0, right, nohscroll;')
disp('	fontset = help, "Arial", 10, L0, nohscroll;')
disp('	fontset = clipboard, "Arial", 12, L0, nohscroll;')
disp('	fontset = completions, "Arial", 12, L0, nowordwrap, nohscroll;')
disp('	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;')
disp('	fontset = special1, "Arial", 12, L0, nowordwrap, nohscroll;')
disp('	fontset = special2, "Arial", 12, L0, center, nowordwrap, nohscroll;')
disp('	fontset = special3, "Arial", 12, L0, right, nowordwrap, nohscroll;')
disp('	fontset = special4, "Arial", 12, L0, nowordwrap, nohscroll;')
disp('	fontset = special5, "Arial", 12, L0, nowordwrap, nohscroll;')
disp('	fontset = leftheader, "Arial", 12, L0, nowordwrap, nohscroll;')
disp('	fontset = leftfooter, "Arial", 12, L0, nowordwrap, nohscroll;')
disp('	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]')
disp(':[font = title; inactive; nohscroll; center; ]')
disp('Drawing Schematics of Filters and Systems')
disp(':[font = subsubtitle; inactive; nohscroll; center; ]')
disp('Prof. Dr Miroslav D. Lutovac and Prof. Dr Dejan V. Tosic')
disp(':[font = section; inactive; ]')
disp('Info')
disp(':[font = info; inactive; nowordwrap; ]')
disp('(*  DrawMath                                                      ')
disp(' Schematic generated from DrawFilt version 2.8                    ')
disp('                                                                  ')
disp(' Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic   ')
disp(' lutovac@kondor.etf.bg.ac.yu  http://kondor.etf.bg.ac.yu/~lutovac/')
disp(' tosic@galeb.etf.bg.ac.yu     http://www.rcub.bg.ac.yu/~tosicde/  ')
disp(' Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic       ')
disp(' $Revision: 2.8 $  $Date: 2005/03/04                              ')
disp('                                                                  ')
disp('   Reference:                                                     ')
disp('   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans            ')
disp('        Filter Design for Signal Processing                       ')
disp('           Using MATLAB and Mathematica                           ')
disp('        Prentice Hall    ISBN 0-201-36130-2                       ')
disp('                                                                *)')
disp(':[font = section; inactive; startGroup;  ]')
disp('Initialize: Copy drawflib.mma from DrawFilt to working directory (folder)')
disp(':[font = input; endGroup; nowordwrap; ]')
disp(['SetDirectory["' mypathnamema '"];                            '])
disp('<<drawflib.mma                                                 ')
disp(['<<' myfilenamemma '                                          '])
disp(':[font = section; inactive; ]')
disp('Schematic')
disp(':[font = input; ]')
disp('DrawMath[0,0,1,5,10];')
disp('^*)')
  diary  off

  pause(3)
  title('CLICK a button')
