function [matrixEE,filename,pathname]=bdrwopen(x0,y0,dx,ds,F,Nx,Ny,matrixE,myfilename,mypathname)
% bdrwopen.m  BUTTON: OPEN SCHEMATIC
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2

pathnamea = lower(pwd);
pathnameb = lower([pathnamea '\album']);
matrixEsize = 61;

pathinvname = fliplr(pathnamea);
epathnamea  = strmatch('tlifward',pathinvname);

if size(epathnamea) > 0
   if epathnamea(1) == 1
      existalbum = exist('album','dir');
      if existalbum == 7
         cd(pathnameb);
         [filename, pathname] = uigetfile('*.m', 'Open DrawFilt Schematic');
         filespec = [pathname, filename];
         if filename == 0
            filename = myfilename;
            pathname = mypathname;
            cd(pathnamea);
            matrixEE = matrixE;
            return
         else
            cd(pathname);
         end
      else
         [filename, pathname] = uigetfile('*.m', 'Open DrawFilt Schematic');
         filespec = [pathname, filename];
         if filename == 0
            filename = myfilename;
            pathname = mypathname;
            matrixEE = matrixE;
            cd(pathnamea);
            return
         else
            cd(pathname);
         end
      end
   else
      [filename, pathname] = uigetfile('*.m', 'Open DrawFilt Schematic');
      filespec = [pathname, filename];
         if filename == 0
            filename = myfilename;
            pathname = mypathname;
            matrixEE = matrixE;
            cd(pathnamea);
            return
         else
            cd(pathname);
         end
   end
else
   [filename, pathname] = uigetfile('*.m', 'Open DrawFilt Schematic');
   filespec = [pathname, filename];
         if filename == 0
            filename = myfilename;
            pathname = mypathname;
            matrixEE = matrixE;
            cd(pathnamea);
            return
         else
            cd(pathname);
         end
end

x = x0 + dx*(1:4*Nx)/4;
y = y0 + dx*(1:4*Ny)/4;
XS     =blanks(matrixEsize);
fid=fopen(filespec);
while 1
   xs = fgetl(fid);
   if ~isstr(xs), break, end
   if length(xs) > 2
      if (xs(1:3)=='dra')
         XS=strvcat(XS,xs);
      end
   end
end
fclose(fid);

matrixEE = XS;
[ind1,ind2]=size(matrixEE);
matrixEsize=ind2;