function [xs,matrixEE,txtst,matrixEsizeN,matrixEtagE] = buttonde(matrixE,x,y,ds,F,dc,drawtype,txtst,matrixEsize,matrixEtag)
% buttonde.m  BUTTON: DRAW ELEMENT
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2

if txtst == 1;
   clf;
   xx=repmat(x,length(y),1);
   line(xx,y,'LineStyle','none','Marker','.','MarkerSize',1,'Color','m');
  [nE,ns] = size(matrixE);
  if nE > 1
    for indE = nE:-1:2
      eval(matrixE(indE,:));
    end
  end
  axis('equal')
  txtst = 0;
end

matrixEsizeN = matrixEsize;
matrixEtagE  = matrixEtag;
if     strcmp(drawtype,'inputx')
       [xs,matrixEtag1] = butdrawinput(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'redraw')
       xs = blanks(matrixEsize);
       matrixEE=matrixE;
       matrixEtagE = matrixEtag;
elseif strcmp(drawtype,'output')
       [xs,matrixEtag1] = butdrawoutput(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'linexx')
       [xs,matrixEtag1] = butdrawline(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'linehv')
       [xs,matrixEtag1] = butdrawlhv(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'linevh')
       [xs,matrixEtag1] = butdrawlvh(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'nodexx')
       [xs,matrixEtag1] = butdrawnode(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'textxx')
       [xs,matrixEtag1] = butdrawtext(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'arrowx')
       [xs,matrixEtag1] = butdrawarrow(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'multip')
       [xs,matrixEtag1] = butdrawmultiplier(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'delayx')
       [xs,matrixEtag1] = butdrawdelay(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'adderx')
       [xs,matrixEtag1] = butdrawadder(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'upsamp')
       [xs,matrixEtag1] = butdrawupsampler(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'downsa')
       [xs,matrixEtag1] = butdrawdownsampler(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'blockx')
       [xs,matrixEtag1] = butdrawblock(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'block4')
       [xs,matrixEtag1] = butdraw4termblock(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'ccxxxx') % analog -----------------------
       [xs,matrixEtag1] = butdrawcc(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'otaxxx')
       [xs,matrixEtag1] = butdrawota(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'opamxx')
       [xs,matrixEtag1] = butdrawopam(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'grndxx')
       [xs,matrixEtag1] = butdrawgrnd(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'resxxx')
       [xs,matrixEtag1] = butdrawres(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'capxxx')
       [xs,matrixEtag1] = butdrawcap(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'lndxxx')
       [xs,matrixEtag1] = butdrawlnd(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'impxxx')
       [xs,matrixEtag1] = butdrawimp(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'vsxxxx')
       [xs,matrixEtag1] = butdrawvs(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'csxxxx')
       [xs,matrixEtag1] = butdrawcs(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'cvsxxx')
       [xs,matrixEtag1] = butdrawcvs(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'ccsxxx')
       [xs,matrixEtag1] = butdrawccs(matrixE,x,y,ds,F,dc,matrixEsize);
elseif strcmp(drawtype,'polyli')
       [xs,matrixEtag1] = butdrawpolyline(matrixE,x,y,ds,F,dc,matrixEsize);
else
   xs = blanks(matrixEsize);
   matrixEE = matrixE;
   matrixEtagE = matrixEtag;
end

if strcmp(drawtype,'redraw')
    xs = blanks(matrixEsize);
    matrixEE=matrixE;
    matrixEtagE = matrixEtag;
else
    xsblanks = 10^5;
    while length(xsblanks) ~= 0
       xsblanks = findstr(xs,'  ');
       if length(xsblanks) > 0
           xs(xsblanks(length(xsblanks))+1) = [];
       end
    end
    matrixEE=strvcat(matrixE,xs);
    [ind1,ind2] = size(matrixEE);
    matrixEtagE{ind1} = matrixEtag1;
    matrixEsizeN = ind2;
end

% ----------------------------------------------------------------------

function [xs,matrixEtag1] = butdrawinput(matrixE,x,y,ds,F,dc,matrixEsize)
title('INPUT','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
xs = ['drawin(x(' num2str(xe1) '), y(' num2str(ye1) '), ''IN'',2,ds,F,dc);'];
eval(xs); matrixEtag1 = ans; % eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs);  

function [xs,matrixEtag1] = butdrawoutput(matrixE,x,y,ds,F,dc,matrixEsize)
title('OUTPUT','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
xs = ['drawout(x(' num2str(xe1) '), y(' num2str(ye1) '), ''OUT'',0,ds,F,dc);'];

eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 
function [xs,matrixEtag1] = butdrawline(matrixE,x,y,ds,F,dc,matrixEsize)
  title('LINE 1st point','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('LINE 2nd point','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
xs = ['drawline(x(' num2str(xe1) '), y(' num2str(ye1) '), x(' num2str(xe2) ...
     '), y(' num2str(ye2) '),dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawlhv(matrixE,x,y,ds,F,dc,matrixEsize)
  title('2-segment line horizontal+vertical first point','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('2-segment line horizontal+vertical last point','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
xs = ['drawlhv(x(' num2str(xe1) '), y(' num2str(ye1) '),  x(' num2str(xe2) ...
     '),  y(' num2str(ye2) '),0,dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawlvh(matrixE,x,y,ds,F,dc,matrixEsize)
  title('2-segment line vertical+horizontal first point','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('2-segment line vertical+horizontal last point','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
xs = ['drawlvh(x(' num2str(xe1) '), y(' num2str(ye1) '),  x(' num2str(xe2) ...
     '),  y(' num2str(ye2) '),0,dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawnode(matrixE,x,y,ds,F,dc,matrixEsize)
title('NODE','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'drawnode')) == 0
    indH = indH + 1;
  end
end
Htext = ['''' int2str(indH) ''''];
xs = ['drawnode(x(' num2str(xe1) '), y(' num2str(ye1) '), ' Htext ', 1, 1, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawtext(matrixE,x,y,ds,F,dc,matrixEsize)
title('TEXT','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'drawtext')) == 0
    indH = indH + 1;
  end
end
Htext = ['''t' int2str(indH) ''''];
xs = ['drawtext(x(' num2str(xe1) '), y(' num2str(ye1) '), ' Htext ', F+1, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawarrow(matrixE,x,y,ds,F,dc,matrixEsize)
title('ARROW','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
xs = ['drawarrw(x(' num2str(xe1) '), y(' num2str(ye1) '),'' '',0,ds/2,F,dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawmultiplier(matrixE,x,y,ds,F,dc,matrixEsize)
  title('MULTIPLIER input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('MULTIPLIER  output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'drawmult')) == 0
    indH = indH + 1;
  end
end
Htext = ['''a' int2str(indH) ''''];
xs = ['drawmult(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '' , ' Htext ',' num2str(xyor) ', ds/3, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawdelay(matrixE,x,y,ds,F,dc,matrixEsize)
  title('DELAY input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('DELAY  output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
xs = ['drawdel(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ''-1'' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawadder(matrixE,x,y,ds,F,dc,matrixEsize)
  title('ADDER input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('ADDER output','Color','Red','FontWeight','Bold')
line(xe1,ye1,'Marker','d', 'Color','m')
line(xe1+2,ye1,'Marker','>', 'Color','m')
line(xe1-2,ye1,'Marker','<', 'Color','m')
line(xe1,ye1+2,'Marker','^', 'Color','m')
line(xe1,ye1-2,'Marker','v', 'Color','m')
[xe2,ye2]=ginput(1);   
[xe21 ix21] = min(abs([xe2-(xe1-2) xe2-(xe1+2)]));
[ye21 iy21] = min(abs([ye2-(ye1-2) ye2-(ye1+2)]));
if abs(xe2-xe1) >= abs(ye2-ye1)
  if ix21 == 1
    xe2 = xe1-2;
  else
    xe2 = xe1+2;
  end
  ye2 = ye1;
else
  if iy21 == 1
    ye2 = ye1-2;
  else
    ye2 = ye1+2;
  end
  xe2 = xe1;
end
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 1;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 3;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 2;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 4;
   end
  end
if xyor == 1
  xs = ['drawadd(x(' num2str(xe1) '), y(' num2str(ye1) ...
     '), 2, 1, 1, 3, '' '', ' num2str(xyor) ', ds/3, F, dc);'];
elseif xyor == 3
  xs = ['drawadd(x(' num2str(xe1) '), y(' num2str(ye1) ...
     '), 1, 1, 2, 3, '' '', ' num2str(xyor) ', ds/3, F, dc);'];
elseif xyor == 2
  xs = ['drawadd(x(' num2str(xe1-1) '), y(' num2str(ye1+1) ...
     '), 1, 2, 3, 1, '' '', ' num2str(xyor-1) ', ds/3, F, dc);'];
elseif xyor == 4
  xs = ['drawadd(x(' num2str(xe1-1) '), y(' num2str(ye1+1) ...
     '), 1, 1, 3, 2, '' '', ' num2str(xyor-1) ', ds/3, F, dc);'];
end
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawupsampler(matrixE,x,y,ds,F,dc,matrixEsize)
  title('UP-SAMPLER input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('UP-SAMPLER  output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 5;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'drawupsa')) == 0
    indH = indH + 1;
  end
end
Htext = ['''L' int2str(indH) ''''];
xs = ['drawupsa(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F-1, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawdownsampler(matrixE,x,y,ds,F,dc,matrixEsize)
  title('DOWN-SAMPLER input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('DOWN-SAMPLER output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 5;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'drawdown')) == 0
    indH = indH + 1;
  end
end
Htext = ['''M' int2str(indH) ''''];
xs = ['drawdown(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F-1, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawblock(matrixE,x,y,ds,F,dc,matrixEsize)
  title('BLOCK input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('BLOCK  output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 5;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawblo')) == 0
    indH = indH + 1;
  end
end
Htext = ['''H' int2str(indH) ''''];
xs = ['drawblo(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdraw4termblock(matrixE,x,y,ds,F,dc,matrixEsize)
  title('4-terminal Block  x-input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1)-1;
  title('4-terminal Block  z-output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
if xe2 < (xe1+3)
  xy = xe1;
  xe1 = xe2;
  xys ='x';
  xyor = 2;
else
  xy = xe2;
  xys ='x';
  xyor = 0;
end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'draw4tbl')) == 0
    indH = indH + 1;
  end
end
Htext = ['''a' int2str(indH) ''''];
xs = ['draw4tbl(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

% ANALOG ------------------------------------------------

function [xs,matrixEtag1] = butdrawcc(matrixE,x,y,ds,F,dc,matrixEsize)
  title('CC  x-input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1)-1;
  title('CC output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
if xe2 < (xe1+3)
  xy = xe1;
  xe1 = xe2;
  xys ='x';
  xyor = 2;
else
  xy = xe2;
  xys ='x';
  xyor = 0;
end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawcc(')) == 0
    indH = indH + 1;
  end
end
Htext = ['''a' int2str(indH) ''''];
xs = ['drawcc(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawota(matrixE,x,y,ds,F,dc,matrixEsize)
  title('OTA + input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1)-1;
  title('OTA output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
if xe2 < (xe1+3)
  xy = xe1;
  xe1 = xe2;
  xys ='x';
  xyor = 2;
else
  xy = xe2;
  xys ='x';
  xyor = 0;
end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawota')) == 0
    indH = indH + 1;
  end
end
Htext = ['''gm' int2str(indH) ''''];
xs = ['drawota(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawopam(matrixE,x,y,ds,F,dc,matrixEsize)
  title('OPAMP + input','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1)-1;
  title('OPAMP output','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
if xe2 < (xe1+3)
  xy = xe1;
  xe1 = xe2;
  xys ='x';
  xyor = 2;
else
  xy = xe2;
  xys ='x';
  xyor = 0;
end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:8) - 'drawopam')) == 0
    indH = indH + 1;
  end
end
Htext = ['''A' int2str(indH) ''''];
xs = ['drawopam(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawgrnd(matrixE,x,y,ds,F,dc,matrixEsize)
title('GROUND','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
xs = ['drawgrnd(x(' num2str(xe1) '), y(' num2str(ye1) '), 0, ds/2, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawres(matrixE,x,y,ds,F,dc,matrixEsize)
  title('RESISTOR 1st node','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('RESISTOR 2nd node','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawres')) == 0
    indH = indH + 1;
  end
end
Htext = ['''R' int2str(indH) ''''];
xs = ['drawres(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawcap(matrixE,x,y,ds,F,dc,matrixEsize)
  title('CAPACITOR 1st node','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('CAPACITOR 2nd node','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawcap')) == 0
    indH = indH + 1;
  end
end
Htext = ['''C' int2str(indH) ''''];
xs = ['drawcap(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawlnd(matrixE,x,y,ds,F,dc,matrixEsize)
  title('INDUCTOR 1st node','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('INDUCTOR 2nd node','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawlnd')) == 0
    indH = indH + 1;
  end
end
Htext = ['''L' int2str(indH) ''''];
xs = ['drawlnd(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawimp(matrixE,x,y,ds,F,dc,matrixEsize)
  title('IMPEDANCE 1st node','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('IMPEDANCE 2nd node','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawimp')) == 0
    indH = indH + 1;
  end
end
Htext = ['''Z' int2str(indH) ''''];
xs = ['drawimp(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawvs(matrixE,x,y,ds,F,dc,matrixEsize)
  title('VOLTAGE SOURCE - (NEGATIVE terminal)','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('VOLTAGE SOURCE + (POSITIVE terminal)','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:6) - 'drawvs')) == 0
    indH = indH + 1;
  end
end
Htext = ['''V' int2str(indH) ''''];
xs = ['drawvs(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawcs(matrixE,x,y,ds,F,dc,matrixEsize)
  title('CURRENT SOURCE  *-->','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('-->*  CURRENT SOURCE','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:6) - 'drawcs')) == 0
    indH = indH + 1;
  end
end
Htext = ['''I' int2str(indH) ''''];
xs = ['drawcs(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawccs(matrixE,x,y,ds,F,dc,matrixEsize)
  title('CONTROLLED CURRENT SOURCE  *-->','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('-->*  CONTROLLED CURRENT SOURCE','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawccs')) == 0
    indH = indH + 1;
  end
end
Htext = ['''I' int2str(indH) ''''];
xs = ['drawccs(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawcvs(matrixE,x,y,ds,F,dc,matrixEsize)
  title('CONTROLLED VOLTAGE SOURCE -','Color','Red','FontWeight','Bold')
  [xe1,ye1]=ginput(1);   xe1 = round(xe1); ye1 =round(ye1);
  title('CONTROLLED VOLTAGE SOURCE +','Color','Red','FontWeight','Bold')
  [xe2,ye2]=ginput(1);   xe2 = round(xe2); ye2 =round(ye2);
  if abs(xe2-xe1) >= abs(ye2-ye1)
   xy = xe2;
   xys ='x';
   xyor = 0;
   if xy < xe1  
    xtmp = xy;
    xy  = xe1;
    xe1 = xtmp;
   xyor = 2;
   end
  else
   xy = ye2;
   xys ='y';
   xyor = 1;
   if xy < ye1  
    ytmp = xy;
    xy  = ye1;
    ye1 = ytmp;
   xyor = 3;
   end
  end
indH = 1;
[ind1,ind2] = size(matrixE); 
for indi = 1 : ind1
  if sum(abs(matrixE(indi,1:7) - 'drawcvs')) == 0
    indH = indH + 1;
  end
end
Htext = ['''V' int2str(indH) ''''];
xs = ['drawcvs(x(' num2str(xe1) '), y(' num2str(ye1) '), ' xys '(' num2str(xy) ...
     '), '' '', ' Htext ' ,' num2str(xyor) ', ds/2, F, dc);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 

function [xs,matrixEtag1] = butdrawpolyline(matrixE,x,y,ds,F,dc,matrixEsize)
  title('PolyLine 1st point','Color','Red','FontWeight','Bold')
  but = 1;
  [xe1,ye1,but] = ginput(1);
  xe1 = round(xe1); ye1 =round(ye1);
  xe = xe1;
  ye = ye1;
  title('PolyLine next point','Color','Red','FontWeight','Bold')
  [xe2,ye2,but] = ginput(1);
  xe2 = round(xe2); ye2 =round(ye2);
  xe = [xe xe2];
  ye = [ye ye2];
  xs = ['drawpoly(x([' num2str(xe) ']), y([' num2str(ye) ']), ''--'',0.5, ''m'', ''none'',6);'];
  eval(xs);
  while ((but == 1)|(but == 13))
      title('Click LEFT mouse button for NEXT PolyLine point, RIGHT to FINISH','Color','Red','FontWeight','Bold')
      [xe3,ye3,but] = ginput(1);
      if ((but == 1)|(but == 13)) == 1
          xe3 = round(xe3); ye3 =round(ye3);
          xe = [xe xe3];
          ye = [ye ye3];
          xs = ['drawpoly(x([' num2str(xe) ']), y([' num2str(ye) ']), ''--'',0.5, ''m'', ''none'',6);'];
          eval(xs);
      end
  end
xs = ['drawpoly(x([' num2str(xe) ']),y([' num2str(ye) ']),''--'',0.5,''m'',''none'',6);'];
eval(xs); matrixEtag1 = ans; % matrixEtag1 = eval(xs); 