function matrixE1 = dfcomp(matrixEsIn)
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

[nE,ns] = size(matrixEsIn);
matrixE1 = [];
tmpstr = '''';

for indE = 1:nE;
    matrixEs1 = matrixEsIn{indE,1};
    for ind0 = 1:ns
        matrixE0{ind0} = matrixEsIn{indE,ind0};
    end
    if strcmp(matrixEs1,'in')|strcmp(matrixEs1,'out')|strcmp(matrixEs1,'node')|strcmp(matrixEs1,'arrw')
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s tmpstr matrixE0{4} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'line')
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s 'x(' matrixE0{9} '),' 'y(' matrixE0{11} '),'];
    matrixE1s = [matrixE1s matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'lhv')|strcmp(matrixEs1,'lvh')
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s 'x(' matrixE0{9} '),' 'y(' matrixE0{11} '),'];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'text')
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s tmpstr matrixE0{4} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'del')|strcmp(matrixEs1,'blo')|strcmp(matrixEs1,'mult')|strcmp(matrixEs1,'down')|strcmp(matrixEs1,'upsa')
    P = str2num(matrixE0{5});
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    if (P-2*fix(P/2)) == 0
        matrixE1s = [matrixE1s 'x(' matrixE0{9} '),'];
    else
        matrixE1s = [matrixE1s 'y(' matrixE0{9} '),'];
    end
    matrixE1s = [matrixE1s tmpstr matrixE0{4} tmpstr ','];
    matrixE1s = [matrixE1s tmpstr matrixE0{10} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'add')
    P = str2num(matrixE0{5});
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s matrixE0{4} ','];
    matrixE1s = [matrixE1s tmpstr matrixE0{10} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'poly')
    P = str2num(matrixE0{5});
    matrixE1s = ['draw' matrixE0{1} '(x([' matrixE0{2} ']),y([' matrixE0{3} ']),'];
%    matrixE1s = [matrixE1s '''' matrixE0{4} '''' ','];
    matrixE1s = [matrixE1s matrixE0{4} ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{8} ',' matrixE0{6} ',' matrixE0{7} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
    
  elseif strcmp(matrixEs1,'cap')|strcmp(matrixEs1,'imp')|strcmp(matrixEs1,'res')|strcmp(matrixEs1,'lnd')|strcmp(matrixEs1,'vs')|strcmp(matrixEs1,'cs')|strcmp(matrixEs1,'ccs')|strcmp(matrixEs1,'cvs')
    P = str2num(matrixE0{5});
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    if (P-2*fix(P/2)) == 0
        matrixE1s = [matrixE1s 'x(' matrixE0{9} '),'];
    else
        matrixE1s = [matrixE1s 'y(' matrixE0{9} '),'];
    end
    matrixE1s = [matrixE1s tmpstr matrixE0{4} tmpstr ','];
    matrixE1s = [matrixE1s tmpstr matrixE0{10} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'opam')|strcmp(matrixEs1,'cc')|strcmp(matrixEs1,'ota')|strcmp(matrixEs1,'4tbl')
    P = str2num(matrixE0{5});
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s 'x(' matrixE0{9} '),'];
    matrixE1s = [matrixE1s tmpstr matrixE0{4} tmpstr ','];
    matrixE1s = [matrixE1s tmpstr matrixE0{10} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  elseif strcmp(matrixEs1,'grnd')
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  else
    P = str2num(matrixE0{5});
    matrixE1s = ['draw' matrixE0{1} '(x(' matrixE0{2} '),y(' matrixE0{3} '),'];
    if (P-2*fix(P/2)) == 0
        matrixE1s = [matrixE1s 'x(' matrixE0{9} '),'];
    else
        matrixE1s = [matrixE1s 'y(' matrixE0{9} '),'];
    end
    matrixE1s = [matrixE1s tmpstr matrixE0{4} tmpstr ','];
    matrixE1s = [matrixE1s tmpstr matrixE0{10} tmpstr ','];
    matrixE1s = [matrixE1s matrixE0{5} ',' matrixE0{6} ',' matrixE0{7} ',' matrixE0{8} ');'];
    matrixE1 = strvcat(matrixE1,matrixE1s);
  end
end
