function [matrixEs,newmatrixEs] = dfdecomp(matrixE)
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

[nE,ns] = size(matrixE);
compstring1 = 'draw'; n1 = 4;
compstring2 = '(';    n2 = 1;
compstring3 = 'x(';   n3 = 2;
compstring4 = ')';    n4 = 1;
compstring5 = 'y(';   n5 = 2;
compstring6 = ',';    n6 = 1;
compstring7 = '''';   n7 = 1;
compstring8 = '(';    n8 = 1;

for indE = 1:nE;
 t1 = deblank(matrixE(indE,:));
 if length(t1) ~= 0
  [matrixEs1,newmatrixEs1] = mydecompose(t1,compstring1,n1,compstring2,n2);
  matrixEs{indE,1} = matrixEs1;
  newmatrixEs{indE,1} = newmatrixEs1;

  % -------- in out node arrw -------------
  if strcmp(matrixEs1,'in')|strcmp(matrixEs1,'out')|strcmp(matrixEs1,'node')|strcmp(matrixEs1,'arrw')
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  % -------- line -------------
  elseif strcmp(matrixEs1,'line')
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,9} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,9} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,11} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,11} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    matrixEs{indE,5} = [];
    matrixEs{indE,6} = [];
    matrixEs{indE,7} = [];
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  % -------- lhv lvh -------------
  elseif strcmp(matrixEs1,'lhv')|strcmp(matrixEs1,'lvh')
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,9} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,9} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,11} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,11} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    matrixEs{indE,4} = [];
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    matrixEs{indE,6} = [];
    matrixEs{indE,7} = [];
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  elseif strcmp(matrixEs1,'text') % -------- text -------------
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    matrixEs{indE,5} = [];
    matrixEs{indE,6} = [];
    
    [matrixEs1,newmatrixEs1] = mydecompose3(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  % -------- del blo mult down upsa-------------
  elseif strcmp(matrixEs1,'del')|strcmp(matrixEs1,'blo')|strcmp(matrixEs1,'mult')|strcmp(matrixEs1,'down')|strcmp(matrixEs1,'upsa')
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring2,n2,compstring4,n4);
    matrixEs{indE,9} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,9} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,10} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  elseif strcmp(matrixEs1,'add')     % -------- add-------------
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,4} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,4})
        matrixEs{indE,4} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring6,n6);
    tmpstr4 = num2str(round(str2num(matrixEs1)));
    matrixEs{indE,4} = [matrixEs{indE,4} ',' tmpstr4];
    if isempty(tmpstr4)
        matrixEs{indE,4} = [matrixEs{indE,4} ',0'];
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring6,n6);
    tmpstr4 = num2str(round(str2num(matrixEs1)));
    matrixEs{indE,4} = [matrixEs{indE,4} ',' tmpstr4];
    if isempty(tmpstr4)
        matrixEs{indE,4} = [matrixEs{indE,4} ',0'];
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring6,n6);
    tmpstr4 = num2str(round(str2num(matrixEs1)));
    matrixEs{indE,4} = [matrixEs{indE,4} ',' tmpstr4];
    if isempty(tmpstr4)
        matrixEs{indE,4} = [matrixEs{indE,4} ',0'];
    end
    newmatrixEs{indE,1} = newmatrixEs1;

    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring7,n7,compstring7,n7);
    matrixEs{indE,10} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
       newmatrixEs{indE,1} = newmatrixEs1;

   elseif strcmp(matrixEs1,'poly')     % -------- poly -------------
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = ['''' matrixEs1 ''''];
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(str2num(matrixEs1));
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring4,n4);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  % -------- cap imp res lnd vs cs ccs cvs -------------
  elseif strcmp(matrixEs1,'cap')|strcmp(matrixEs1,'imp')|strcmp(matrixEs1,'res')|strcmp(matrixEs1,'lnd')|strcmp(matrixEs1,'vs')|strcmp(matrixEs1,'cs')|strcmp(matrixEs1,'ccs')|strcmp(matrixEs1,'cvs')
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring2,n2,compstring4,n4);
    matrixEs{indE,9} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,9} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,10} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  % -------- opam cc ota -------------
  elseif strcmp(matrixEs1,'opam')|strcmp(matrixEs1,'cc')|strcmp(matrixEs1,'ota')
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring2,n2,compstring4,n4);
    matrixEs{indE,9} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,9} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,10} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  elseif strcmp(matrixEs1,'grnd')  % -------- grnd -------------
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    matrixEs{indE,4} = [];
   [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    matrixEs{indE,7} = [];
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  else  % -------- else -------------
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring3,n3,compstring4,n4);
    matrixEs{indE,2} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,2})
        matrixEs{indE,2} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring5,n5,compstring4,n4);
    matrixEs{indE,3} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,3} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring2,n2,compstring4,n4);
    matrixEs{indE,9} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,3})
        matrixEs{indE,9} = '1';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,4} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring7,n7);
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring7,n7);
    matrixEs{indE,10} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose(newmatrixEs1,compstring6,n6,compstring6,n6);
    matrixEs{indE,5} = num2str(round(str2num(matrixEs1)));
    if isempty(matrixEs{indE,5})
        matrixEs{indE,5} = '0';
    end
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,6} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose2(newmatrixEs1,compstring6,n6);
    matrixEs{indE,7} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;
    
    [matrixEs1,newmatrixEs1] = mydecompose1(newmatrixEs1,compstring4,n4);
    matrixEs{indE,8} = matrixEs1;
    newmatrixEs{indE,1} = newmatrixEs1;

  end
 else
 matrixEs{indE,1}  = '0';
 matrixEs{indE,2}  = '0';
 matrixEs{indE,3}  = '0';
 matrixEs{indE,4}  = '0';
 matrixEs{indE,5}  = '0';
 matrixEs{indE,6}  = '0';
 matrixEs{indE,7}  = '0';
 matrixEs{indE,8}  = '0';
 matrixEs{indE,9}  = '0';
 matrixEs{indE,10} = '0';
 matrixEs{indE,11} = '0';
 end
end

function [matrixEs1,newmatrixEs1] = mydecompose(t1,compstring1,n1,compstring2,n2)
% mystrN1 = strfind(t1,compstring1);
 mystrN1 = findstr(t1,compstring1);
 mystrL1 = mystrN1(1) + n1;
% mystrN2 = strfind(t1(mystrL1:end),compstring2); 
 mystrN2 = findstr(t1(mystrL1:end),compstring2); 
 matrixEs1 = t1(mystrL1:mystrL1+mystrN2(1)-2);
 newmatrixEs1 = t1(mystrL1+mystrN2(1)+n2-1:end);

function [matrixEs1,newmatrixEs1] = mydecompose1(t1,compstring2,n2)
% mystrN2 = strfind(t1,compstring2); 
 mystrN2 = findstr(t1,compstring2); 
 matrixEs1 = t1(1:mystrN2(1)-1);
 newmatrixEs1 = t1(mystrN2(1)+n2:end);

function [matrixEs1,newmatrixEs1] = mydecompose2(t1,compstring2,n2)
% mystrN2 = strfind(t1,compstring2); 
 mystrN2 = findstr(t1,compstring2); 
 matrixEs2 = t1(1:mystrN2(1)-1);
% mystrN3 = strfind(matrixEs2,' '); 
 mystrN3 = findstr(matrixEs2,' '); 
 mystrN4 = length(mystrN3);
 if  mystrN4 > 0
     for ind = mystrN4:-1:1
         matrixEs2(mystrN3(ind)) = [];
     end
 end
 matrixEs1 = matrixEs2;
 newmatrixEs1 = t1(mystrN2(1)+n2:end);

function [matrixEs1,newmatrixEs1] = mydecompose3(t1,compstring1,n1,compstring2,n2)
% mystrN1 = strfind(t1,compstring1);
 mystrN1 = findstr(t1,compstring1);
 mystrL1 = mystrN1(1) + n1;
% mystrN2 = strfind(t1(mystrL1:end),compstring2); 
 mystrN2 = findstr(t1(mystrL1:end),compstring2); 

 matrixEs1 = t1(mystrL1:mystrL1+mystrN2(1)-2);
% mystrN3 = strfind(matrixEs1,' '); 
 mystrN3 = findstr(matrixEs1,' '); 
 mystrN4 = length(mystrN3);
 if  mystrN4 > 0
     for ind = mystrN4:-1:1
         matrixEs1(mystrN3(ind)) = [];
     end
 end
 newmatrixEs1 = t1(mystrL1+mystrN2(1)+n2-1:end);

% ---- end of file ---
