% dfedita
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mycolors1 = ['dc|' '''b''' '|' '''g''' '|' '''r''' '|' '''m''' '|' '''c''' '|' '''y''' '|' '''k'''];
mycolors2 = {'dc';  '''b''' ;  '''g'''  ;  '''r'''  ;  '''m'''  ;  '''c'''  ;  '''y'''  ;  '''k'''};
mylinestyle1 = ['''--''' '|' ''':''' '|' '''-.''' '|' '''-'''];
mylinestyle2 = {'''--'''  ;  ''':'''  ;  '''-.'''  ;  '''-'''};
mylinewidth1 = ['0.5' '|' '2' '|' '3' '|' '4' '|' '5' '|' '6' '|' '12' '|' '24'];
mylinewidth2 = {'0.5'  ;  '2'  ;  '3'  ;  '4'  ;  '5'  ;  '6'  ;  '12'  ;  '24'};
mylinefont1 = ['F' '|' 'F+1' '|' 'F-1' '|' 'F+2' '|' 'F-2' '|' 'F+3' '|' 'F-3'];
mylinefont2 = {'F'  ;  'F+1'  ;  'F-1'  ;  'F+2'  ;  'F-2'  ;  'F+3'  ;  'F-3'};
mydrawsize1 = ['ds/3' '|' 'ds/2' '|' '2*ds/3' '|' 'ds' '|' '2*ds' '|' '3*ds/2' '|' 'ds/4'];
mydrawsize2 = {'ds/3'  ;  'ds/2'  ;  '2*ds/3'  ;  'ds'  ;  '2*ds'  ;  '3*ds/2'  ;  'ds/4'};
mydrawsize3 = ['ds/3' '|' '2*ds/3' '|' 'ds'];
mydrawsize4 = {'ds/3'  ;  '2*ds/3'  ;  'ds'};
mylinemarker1 = ['''none''' '|' '''o''' '|' '''x''' '|' '''*''' '|' '''s''' '|' '''d''' '|' '''+'''];
mylinemarker2 = {'''none'''  ;  '''o'''  ;  '''x'''  ;  '''*'''  ;  '''s'''  ;  '''d'''  ;  '''+'''};
if matrixEeditind == 0
    editString=[0 1];
    clf;
    [x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);
    matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);
    butdraw;
else
    [nE,ns] = size(matrixE);
    [matrixEs,newmatrixEs] = dfdecomp(matrixE(matrixEeditind,:));
    matrixEsNew = matrixEs;
    matrixEsNew{11} = [];
    %  ---   close   -------------------------
    uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0 0 0.6] ...
     , 'Position', [0.905 0.84 0.095 0.2] ...
     , 'String', ' ');

    
    callbackStrClose = ['editString=[0 1];clf;[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);'];
    callbackStrClose = [callbackStrClose 'matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);'];
    callbackStrClose = [callbackStrClose 'butdraw;EditChangeStr1=0;'];
    callbackStrClose = [callbackStrClose 'if exist(''myfigpos2'',''var'')==1; close(figure(myfigpos2)); end;'];
    uicontrol('String', 'close edit', 'Units', 'normalized' ...
     , 'Position', [0.91 0.94 0.09 0.05] ...
     , 'CallBack', callbackStrClose);
 
    callbackStrApply = 'matrixEs{4}=matrixEsNew{4};matrixEs{5}=matrixEsNew{5};matrixEs{8}=matrixEsNew{8};';
    callbackStrApply = [callbackStrApply 'matrixEs{6}=matrixEsNew{6};matrixEs{7}=matrixEsNew{7};'];
    callbackStrApply = [callbackStrApply 'matrixEs{10}=matrixEsNew{10};'];
    callbackStrApply = [callbackStrApply 'clf;[x,y]= drawgrid(x0,y0,dx,ds,F,Nx,Ny);'];
    callbackStrApply = [callbackStrApply 'matrixE=strvcat(matrixE,dfcomp(matrixEs));'];
    callbackStrApply = [callbackStrApply 'matrixE(matrixEeditind,:)=matrixE(nE+1,:);matrixE(nE+1,:)=[];'];
    callbackStrApply = [callbackStrApply 'matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);dfedita'];
    bApply = uicontrol('String', 'Apply', 'Units', 'normalized' ...
     , 'Position', [0.91 0.85 0.085 0.04] ...
     , 'CallBack', callbackStrApply);
 
    uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0 0 0.6] ...
     , 'Position', [0.005 0.005 0.094 0.99] ...
     , 'String', ' ');

    uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0 0 0.6] ...
     , 'Position', [0.005 0.005 0.61 0.07] ...
     , 'String', ' ');
 
mybutton{53,2} = uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.99 0.99 0.099] ...
     , 'Position', [0.15 0.97 0.665 0.025] ...
     , 'String', mypathname);
 
mybutton{54,2} = uicontrol('Style', 'text', 'Units', 'normalized' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.99 0.99 0.092] ...
     , 'Position', [0.71 0.01 0.29 0.04] ...
     , 'String', myfilename);
 
mybutton{51,2} = uicontrol('String', 'save', 'Units', 'normalized', ...
         'Position', [0.92 0.59 0.08 0.05], ...
         'CallBack', '[myfilename,mypathname]=bdrwsave(matrixE,myfilename,mypathname);');

%mybutton{52,2} = uicontrol('String', 'save as', 'Units', 'normalized' ...
%     , 'Position', [0.92 0.66 0.08 0.05] ...
%     , 'CallBack', ['[myfilename,mypathname]=bdrwsaas(matrixE,myfilename,mypathname);' ...
%       'myfilenamem = myfilename(1:(length(myfilename)-2));' ...
%     'matrixEtag=bdrwredr(x0,y0,dx,ds,F,Nx,Ny,matrixE,dc);butdraw']);

 
    uicontrol('Style', 'text', 'Units', 'normalized', 'FontSize', 12 ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
     , 'Position', [0.01 0.940 0.08 0.05] ...
     , 'String', 'Edit');

    uicontrol('Style', 'text', 'Units', 'normalized', 'FontSize', 10, 'FontWeight', 'Bold' ...
     , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
     , 'Position', [0.01 0.885 0.08 0.05] ...
     , 'String',   [' ' matrixEs{1}]);
 
    if strcmp(matrixEs{1},'add')
         addertype = str2num(matrixEs{4});
         bbNew1 = num2str(addertype(1)); bbNew2 = num2str(addertype(2));
         bbNew3 = num2str(addertype(3)); bbNew4 = num2str(addertype(4));
    end
    if strcmp(matrixEs{1},'in')|strcmp(matrixEs{1},'out')|strcmp(matrixEs{1},'arrw')...
      |strcmp(matrixEs{1},'node')
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Scale = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['Font = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.01 0.6 0.035] ...
         , 'String', ['Label = ']);
         
        mylinefont5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinefont1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(mylinefont5c12,''Value''); matrixEsNew{7}=char(mylinefont2(matrixEsNew7));');

        mydrawsize5c12 = uicontrol('Style', 'popup' ...
         , 'String', mydrawsize1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.445 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew6=get(mydrawsize5c12,''Value''); matrixEsNew{6}=char(mydrawsize2(matrixEsNew6));');
    
        bs1newb = uicontrol('Style', 'edit', 'String', matrixEs{4} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.01 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{4} = get(bs1newb,''String'');'] );
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');

        if strcmp(matrixEs{1},'node')|strcmp(matrixEs{1},'arrw')
            et5b11 = uicontrol('Style', 'popupmenu' ...
             , 'Units', 'normalized' ...
             , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
             , 'Position', [0.01 0.555 0.08 0.05] ...
             , 'String', '0|1|2|3|4|5|6|7' ...
             , 'Value', 1+str2num(matrixEs{5}) ...
             , 'Interruptible','on' ...
             , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
        else
            et5b11 = uicontrol('Style', 'popupmenu' ...
             , 'Units', 'normalized' ...
             , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
             , 'Position', [0.01 0.555 0.08 0.05] ...
             , 'String', '0|1|2|3' ...
             , 'Value', 1+str2num(matrixEs{5}) ...
             , 'Interruptible','on' ...
             , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
        end
            if strcmp(matrixEs{1},'in')|strcmp(matrixEs{1},'out')
                callbackStrDemo = 'myfigpos2 = figure(''Position'',mypos(2,:));clf;';
                callbackStrDemo = [callbackStrDemo 'set(myfigpos2,''Name'', ''demo'', ''NumberTitle'', ''off'');'];
                callbackStrDemo = [callbackStrDemo 'drawin(1, 1, ''p=0'',0,1,8,''r'');'];
                callbackStrDemo = [callbackStrDemo 'drawin(1, 2, ''p=1'',1,1,8,''r'');'];
                callbackStrDemo = [callbackStrDemo 'drawin(1, 3, ''p=2'',2,1,8,''r'');'];
                callbackStrDemo = [callbackStrDemo 'drawin(1, 4, ''p=3'',3,1,8,''r'');'];
                callbackStrDemo = [callbackStrDemo 'axis(''off''); axis(''equal'');figure(mydffig1);'];
                bDemo = uicontrol('String', 'demo', 'Units', 'normalized' ...
                 , 'Position', [0.91 0.75 0.085 0.04], 'CallBack', callbackStrDemo);
            end
            
    elseif strcmp(matrixEs{1},'lhv')|strcmp(matrixEs{1},'lvh')
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ' ' matrixEs{9} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ' ' matrixEs{11} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
        et5b11 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', 1+str2num(matrixEs{5}) ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
    elseif strcmp(matrixEs{1},'line')
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ' ' matrixEs{9} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ' ' matrixEs{11} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
    elseif strcmp(matrixEs{1},'poly')
        matrixEsNew4   = matrixEs{4};
        matrixEsNew{4} = char(matrixEsNew4);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.04 0.6 0.034] ...
         , 'String', ['x = [' matrixEs{2} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.001 0.6 0.034] ...
         , 'String', ['y = [' matrixEs{3} ']']);
     
        uicontrol('Style', 'text', 'Units', 'normalized', 'FontName', 'Courier' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['LineStyle = ' matrixEs{4}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['LineWidth = ' matrixEs{5}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Marker = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['MarkerSize = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
     
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
     
        et5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinestyle1, 'FontName', 'Courier' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.665 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew4=get(et5c12,''Value''); matrixEsNew{4}=char(mylinestyle2(matrixEsNew4));');
     
        lw5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinewidth1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew5=get(lw5c12,''Value''); matrixEsNew{5}=char(mylinewidth2(matrixEsNew5));');

        mylinemarker5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinemarker1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.445 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew6=get(mylinemarker5c12,''Value''); matrixEsNew{6}=char(mylinemarker2(matrixEsNew6));');
     
        markersize5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinewidth1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(markersize5c12,''Value''); matrixEsNew{7}=char(mylinewidth2(matrixEsNew7));');
    
    elseif strcmp(matrixEs{1},'del')|strcmp(matrixEs{1},'blo')|strcmp(matrixEs{1},'mult')|strcmp(matrixEs{1},'down')|strcmp(matrixEs{1},'upsa')
        u = matrixEs{2};
        v = matrixEs{3};
        P = str2num(matrixEs{5});
        if (P-2*fix(P/2)) == 0
            u = matrixEs{9};
        else
            v = matrixEs{9};
        end
       uicontrol('Style', 'text', 'Units', 'normalized' ...
        , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
        , 'Position', [0.01 0.775 0.08 0.1] ...
        , 'String', ['x = [' matrixEs{2} ' ' u ']']);
    
       uicontrol('Style', 'text', 'Units', 'normalized' ...
        , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
        , 'Position', [0.01 0.665 0.08 0.1] ...
        , 'String', ['y = [' matrixEs{3} ' ' v ']']);
    
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        et5b11 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'String', '0|1|2|3|4|5|6|7' ...
         , 'Value', 1+str2num(matrixEs{5}) ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
     
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Scale = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['Font = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);

        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.01 0.6 0.035] ...
         , 'String', ['Label = ']);         
        bs1newb = uicontrol('Style', 'edit', 'String', matrixEs{4} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.01 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{4} = get(bs1newb,''String'');'] );
    
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.045 0.6 0.035] ...
         , 'String', ['Value = ']);         
        bs1newb2 = uicontrol('Style', 'edit', 'String', matrixEs{10} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.045 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{10} = get(bs1newb2,''String'');'] );
     
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
     
        mydrawsize5c12 = uicontrol('Style', 'popup' ...
         , 'String', mydrawsize1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.445 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew6=get(mydrawsize5c12,''Value''); matrixEsNew{6}=char(mydrawsize2(matrixEsNew6));');
    
        mylinefont5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinefont1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(mylinefont5c12,''Value''); matrixEsNew{7}=char(mylinefont2(matrixEsNew7));');
     
    elseif strcmp(matrixEs{1},'add')
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Scale = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['Font = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.01 0.6 0.035] ...
         , 'String', ['Label = ']);

        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'center', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.051 0.13 0.03 0.04] ...
         , 'String', '+', 'FontSize', 12);
     
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.045 0.6 0.035] ...
     , 'String', ['right = ' num2str(addertype(1)) ',  up = ' num2str(addertype(2)) ...
         ',  left = ' num2str(addertype(3)) ',  down = ' num2str(addertype(4)) ...
         '   (2=output; 1=+input; 3=-input; 0=no connection)']);
     
        et5bb0 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.081 0.12 0.05 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', addertype(1)+1 ...
         , 'Interruptible','on' ...
  , 'Callback', ['bbNew1 = num2str(get(gco,''value'')-1);' ...
           'matrixEsNew4=[bbNew1 '','' bbNew2 '','' bbNew3 '','' bbNew4];matrixEsNew{4}=matrixEsNew4;']);
        et5bb1 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.05 0.17 0.05 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', addertype(2)+1 ...
         , 'Interruptible','on' ...
  , 'Callback', ['bbNew2 = num2str(get(gco,''value'')-1);' ...
           'matrixEsNew4=[bbNew1 '','' bbNew2 '','' bbNew3 '','' bbNew4];matrixEsNew{4}=matrixEsNew4;']);
        et5bb2 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.001 0.12 0.05 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', addertype(3)+1 ...
         , 'Interruptible','on' ...
  , 'Callback', ['bbNew3 = num2str(get(gco,''value'')-1);' ...
           'matrixEsNew4=[bbNew1 '','' bbNew2 '','' bbNew3 '','' bbNew4];matrixEsNew{4}=matrixEsNew4;']);
        et5bb3 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.05 0.07 0.05 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', addertype(4)+1 ...
         , 'Interruptible','on' ...
  , 'Callback', ['bbNew4 = num2str(get(gco,''value'')-1);' ...
           'matrixEsNew4=[bbNew1 '','' bbNew2 '','' bbNew3 '','' bbNew4];matrixEsNew{4}=matrixEsNew4;']);
     
        mydrawsize5c12 = uicontrol('Style', 'popup' ...
         , 'String', mydrawsize3 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.445 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew6=get(mydrawsize5c12,''Value''); matrixEsNew{6}=char(mydrawsize4(matrixEsNew6));');
    
        et5b11 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'String', '0|1|2|3|4|5|6|7' ...
         , 'Value', 1+str2num(matrixEs{5}) ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
        bs1newb = uicontrol('Style', 'edit', 'String', matrixEs{10} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.01 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{10} = get(bs1newb,''String'');'] );
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
        mylinefont5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinefont1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(mylinefont5c12,''Value''); matrixEsNew{7}=char(mylinefont2(matrixEsNew7));');
     
    elseif strcmp(matrixEs{1},'text')
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['Font = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.01 0.6 0.035] ...
         , 'String', ['Label = ']);
         
        mylinefont5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinefont1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(mylinefont5c12,''Value''); matrixEsNew{7}=char(mylinefont2(matrixEsNew7));');

        bs1newb = uicontrol('Style', 'edit', 'String', matrixEs{4} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.01 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{4} = get(bs1newb,''String'');'] );
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');

     
    elseif strcmp(matrixEs{1},'grnd')
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Scale = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);
        et5b11 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', 1+str2num(matrixEs{5}) ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
        mydrawsize5c12 = uicontrol('Style', 'popup' ...
         , 'String', mydrawsize1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.445 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew6=get(mydrawsize5c12,''Value''); matrixEsNew{6}=char(mydrawsize2(matrixEsNew6));');
     
    elseif strcmp(matrixEs{1},'res')|strcmp(matrixEs{1},'cap')|strcmp(matrixEs{1},'lnd')|strcmp(matrixEs{1},'imp') ...
        |strcmp(matrixEs{1},'vs')|strcmp(matrixEs{1},'cs')|strcmp(matrixEs{1},'cvs')|strcmp(matrixEs{1},'ccs')
        u = matrixEs{2};
        v = matrixEs{3};
        P = str2num(matrixEs{5});
        if (P-2*fix(P/2)) == 0
            u = matrixEs{9};
        else
            v = matrixEs{9};
        end
       uicontrol('Style', 'text', 'Units', 'normalized' ...
        , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
        , 'Position', [0.01 0.775 0.08 0.1] ...
        , 'String', ['x = [' matrixEs{2} ' ' u ']']);
    
       uicontrol('Style', 'text', 'Units', 'normalized' ...
        , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
        , 'Position', [0.01 0.665 0.08 0.1] ...
        , 'String', ['y = [' matrixEs{3} ' ' v ']']);
    
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        et5b11 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', 1+str2num(matrixEs{5}) ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
     
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Scale = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['Font = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);

        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.01 0.6 0.035] ...
         , 'String', ['Label = ']);         
        bs1newb = uicontrol('Style', 'edit', 'String', matrixEs{4} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.01 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{4} = get(bs1newb,''String'');'] );
    
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.045 0.6 0.035] ...
         , 'String', ['Value = ']);         
        bs1newb2 = uicontrol('Style', 'edit', 'String', matrixEs{10} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.045 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{10} = get(bs1newb2,''String'');'] );
     
        mylinefont5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinefont1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(mylinefont5c12,''Value''); matrixEsNew{7}=char(mylinefont2(matrixEsNew7));');
    
        mydrawsize5c12 = uicontrol('Style', 'popup' ...
         , 'String', mydrawsize1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.445 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew6=get(mydrawsize5c12,''Value''); matrixEsNew{6}=char(mydrawsize2(matrixEsNew6));');

        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
     
    elseif strcmp(matrixEs{1},'4tbl')|strcmp(matrixEs{1},'opam')|strcmp(matrixEs{1},'ota')|strcmp(matrixEs{1},'cc')
        u = matrixEs{9};
        v = matrixEs{3};
       uicontrol('Style', 'text', 'Units', 'normalized' ...
        , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
        , 'Position', [0.01 0.775 0.08 0.1] ...
        , 'String', ['x = [' matrixEs{2} ' ' u ']']);
    
       uicontrol('Style', 'text', 'Units', 'normalized' ...
        , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
        , 'Position', [0.01 0.665 0.08 0.1] ...
        , 'String', ['y = [' matrixEs{3} ' ' v ']']);
    
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.555 0.08 0.1] ...
         , 'String', ['Type = ' matrixEs{5}]);
        et5b11 = uicontrol('Style', 'popupmenu' ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.555 0.08 0.05] ...
         , 'String', '0|1|2|3' ...
         , 'Value', 1+str2num(matrixEs{5}) ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew{5} = num2str(get(gco,''value'')-1);');
     
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.445 0.08 0.1] ...
         , 'String', ['Scale = ' matrixEs{6}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.335 0.08 0.1] ...
         , 'String', ['Font = ' matrixEs{7}]);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.225 0.08 0.1] ...
         , 'String', ['Color = ' matrixEs{8}]);

        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.01 0.6 0.035] ...
         , 'String', ['Label = ']);         
        bs1newb = uicontrol('Style', 'edit', 'String', matrixEs{4} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.01 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{4} = get(bs1newb,''String'');'] );
    
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.045 0.6 0.035] ...
         , 'String', ['Value = ']);         
        bs1newb2 = uicontrol('Style', 'edit', 'String', matrixEs{10} ...
         , 'Units',    'normalized', 'BackgroundColor',[1 1 1], 'HorizontalAlignment', 'left' ...
         , 'Position', [0.11 0.045 0.5 0.035] ...
         , 'CallBack', ['matrixEsNew{10} = get(bs1newb2,''String'');'] );
     
        mylinefont5c12 = uicontrol('Style', 'popup' ...
         , 'String', mylinefont1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.335 0.08 0.05] ...
         , 'Interruptible','on' ...
        , 'Callback', 'matrixEsNew7=get(mylinefont5c12,''Value''); matrixEsNew{7}=char(mylinefont2(matrixEsNew7));');

        et5b12 = uicontrol('Style', 'popup' ...
         , 'String', mycolors1 ...
         , 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[1 1 1] ...
         , 'Position', [0.01 0.225 0.08 0.05] ...
         , 'Interruptible','on' ...
         , 'Callback', 'matrixEsNew8=get(et5b12,''Value''); matrixEsNew{8}=char(mycolors2(matrixEsNew8));');
    
    else
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.775 0.08 0.1] ...
         , 'String', ['x = [' matrixEs{2} ']']);
        uicontrol('Style', 'text', 'Units', 'normalized' ...
         , 'HorizontalAlignment', 'left', 'BackgroundColor',[0.699 0.99 0.99] ...
         , 'Position', [0.01 0.665 0.08 0.1] ...
         , 'String', ['y = [' matrixEs{3} ']']);
    end

end

title('EDIT parameters, APPLY to confirm changes and CLOSE EDIT procedure','Color','red');