% dfsalbum.m    ALBUM OF DIGITAL FILTER REALIZATIONS (main script)
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

clear all; close all

% ============  Default directory  ========================|
%                                                          |
NEWpathname = lower('c:\afd\DrawFilt'); % Default directory|
%                                                          |
% =========================================================|

NEWpathnames = ['''' NEWpathname ''''];
cdNEWpathname = ['cd ' NEWpathname '; dfsalbum;'];

MYMpathname = path;
MYMpathnamen1 = findstr(lower(MYMpathname),lower('DrawFilt'));
if length(MYMpathnamen1) > 0
  MYMpathnamesa = find(MYMpathname(1:MYMpathnamen1)==';');
  if length(MYMpathnamesa) > 0
    MYMpathnamen2 = MYMpathnamesa(length(MYMpathnamesa));
    MYpathname = MYMpathname(MYMpathnamen2+1:MYMpathnamen1+7);
  else
    MYpathname = MYMpathname(1:MYMpathnamen1+7);
  end
else
  MYpathname = lower('c:\afd\DrawFilt');
end
MYpathnames = ['''' MYpathname ''''];
cdMYpathname = ['cd ' MYpathname '; dfsalbum;'];
pathnamea = lower(pwd);
lpathnamea = length(pathnamea);

if lpathnamea > 7
  epathnamea = sum(abs(pathnamea(lpathnamea-7:lpathnamea)-lower('DrawFilt')));
else
  epathnamea = 1;
end

fig1 = figure; axis off;
xx=get(fig1,'Position')-[100 50 -160 -100];

set(fig1, 'Name', 'Album of Digital Filter Realizations version 2.8'...
       , 'Position', [50 20 650 500] ...
       , 'NumberTitle', 'off' ...
       , 'NextPlot', 'replace' )
whitebg(fig1,[1 1 0.9]);


text(0,1.05,'Album of Digital Filter Realizations', 'FontWeight', 'bold', 'FontName', 'Helvetica')
text(-0.03,0.99,...
'DrawFilt version 2.8, Copyright 1999-2005 M. Lutovac and D. Tosic  ', 'FontWeight', 'bold','FontSize',10, 'FontName', 'Helvetica')
text(0,0.94,...
'This is free software; see LICENSE.TXT for details','FontSize',8, 'FontName', 'Helvetica')

if epathnamea == 0

dfsalbut;

set(gcf,'DefaultTextColor','b')
text(0.0,0.88,'CLICK a button to see a filter realization', 'FontWeight', 'bold', 'FontAngle', 'normal', 'FontName', 'Helvetica')

text(0.0,0.77,'DF1  =  Direct form I,     DF1t =  Direct form I transposed', 'FontName', 'Helvetica')
text(0.0,0.72,'DF2  =  Direct form II,    DF2t =  Direct form II transposed', 'FontName', 'Helvetica')
text(0.0,0.67,'FIR  =  Direct form FIR,   FIRT =  Direct form FIR transposed', 'FontName', 'Helvetica')
text(0.0,0.62,'SYM1 =  Direct form symmetric FIR (Type I)', 'FontName', 'Helvetica')
text(0.0,0.57,'SYM2 =  Direct form symmetric FIR (Type II)', 'FontName', 'Helvetica')
text(0.0,0.52,'ASYM3=  Direct form antisymmetric FIR (Type III)', 'FontName', 'Helvetica')
text(0.0,0.47,'ASYM4=  Direct form antisymmetric FIR (Type IV)', 'FontName', 'Helvetica')
text(0.0,0.42,'LAT1 =  Lattice AR', 'FontName', 'Helvetica')
text(0.0,0.37,'LAT2 =  Lattice allpass', 'FontName', 'Helvetica')
text(0.0,0.32,'LAT3 =  Lattice MA min. phase', 'FontName', 'Helvetica')
text(0.0,0.27,'LAT4 =  Lattice MA max. phase', 'FontName', 'Helvetica')
text(0.0,0.22,'LAT5 =  Lattice ARMA', 'FontName', 'Helvetica')
text(0.0,0.17,'LAT6 =  Lattice coupled-allpass', 'FontName', 'Helvetica')
text(0.0,0.12,'LAT7 =  Lattice coupled-allpass power-complementary', 'FontName', 'Helvetica')
text(0.0,0.07,'SS   =  State-space', 'FontName', 'Helvetica')
text(0.0,0.02,'SCA* =  Scale values applied to (1) single section (2) multiple sections', 'FontName', 'Helvetica')

else
  set(gcf,'DefaultTextColor','m')
  text(0.0,0.85,'Your current working directory is', 'FontName', 'Helvetica')
  text(0.0,0.77,pathnamea)
  set(gcf,'DefaultTextColor','r')
  text(0.0,0.66,'Change your working directory', 'FontWeight', 'bold', 'FontName', 'Helvetica')
  text(0.0,0.56,'to the directory where DrawFilt has been installed.', 'FontName', 'Helvetica')
  set(gcf,'DefaultTextColor','b')
  text(0.0,0.44,'For example, switch to the command window', 'FontWeight', 'bold', 'FontName', 'Helvetica')
  text(0.0,0.36,'and issue a command like this cd c:\afd\DrawFilt', 'FontName', 'Helvetica')
  text(0.0,0.28,'or CLICK a button to change or', 'FontName', 'Helvetica')
  text(0.0,0.20,'browse to find directory DrawFilt', 'FontName', 'Helvetica')
  set(gcf,'DefaultTextColor','k')

  uiCLOSE = uicontrol('String', 'CLOSE', 'Units', 'normalized' ...
     , 'Position', [0.88 0.7 0.1 0.1] ...
     , 'CallBack', 'close(gcf)');

 uitextCD = uicontrol('Style', 'text', 'Units', 'normalized' ...
    , 'HorizontalAlignment', 'center', 'BackgroundColor',[0.5 0.99 0.99] ...
    , 'Position', [0.62 0.02 0.38 0.275] ...
    , 'String',   'Change working directory to');

  uiCDMY = uicontrol('String', MYpathname, 'Units', 'normalized' ...
     , 'Position', [0.63 0.175 0.36 0.07] ...
     , 'CallBack', cdMYpathname);

  % Change directory to DrawFilt and select the file dfsalbum.m
  uiBROWSE = uicontrol('String', 'Browse to find directory DrawFilt', 'Units', 'normalized' ...
     , 'Position', [0.63 0.025 0.36 0.07] ...
     , 'CallBack', ...
   ['[browsefile,browsepath] = uigetfile(''dfsalbum.m'',' ...
   ' ''Change directory to DrawFilt and select the file dfsalbum.m'');' ...
   'if browsepath>0;browsepath1=browsepath(1:length(browsepath)-1);' ...
   'eval([''cd '',browsepath1]);dfsalbum;end']);

  testNEWpathname = [NEWpathname '\dfsalbum.m'];
  % test the existence of the NEWpathname and the file dfsalbum.m
  if exist(testNEWpathname) == 2
    % create the button if the file and directory exist
    uiCDNEW = uicontrol('String', NEWpathname, 'Units', 'normalized' ...
     , 'Position', [0.63 0.1 0.36 0.07] ...
     , 'CallBack', cdNEWpathname);
  end

end
