function mydrawimptag = drawimp(c,d,f,n,t,p,s,F,dc)
% drawimp.m  DRAW IMPEDANCE
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mydrawimptag = ['drawimpx' num2str(c) 'y' num2str(d) 'z' num2str(f) 'p' num2str(p)];

a=(f+c)/2-0.4*s;
b=d;
g=c;
h=(f+d)/2-0.4*s;

if p == 0
 x2 = a + s*[(c-a)/s, 0.1, 0.10, 0.70, 0.70, 0.10, 0.10, 0.70, 0.7, (f-a)/s];
 y2 = b + s*[      0,   0, 0.15, 0.15,-0.15,-0.15, 0.15, 0.15,   0, 0];
 line(x2,y2,'Color',dc,'Tag',mydrawimptag)
 text(a+s*0.4,b+s*0.5,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawimptag)
 text(a+s*0.4,b+s*0.2,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','bottom','Tag',mydrawimptag)
elseif p == 1
 x = g + s*[      0,   0, 0.15, 0.15,-0.15,-0.15, 0.15, 0.15,   0, 0];
 y = h + s*[(d-h)/s, 0.1, 0.10, 0.70, 0.70, 0.10, 0.10, 0.70, 0.7, (f-h)/s];
 line(x,y,'Color',dc,'Tag',mydrawimptag)
 text(g-s*0.25,h+s*0.4,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','top','Tag',mydrawimptag)
 text(g-s*0.25,h+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawimptag)
elseif p == 2
 x2 = a + s*[(c-a)/s, 0.1, 0.10, 0.70, 0.70, 0.10, 0.10, 0.70, 0.7, (f-a)/s];
 y2 = b + s*[      0,   0, 0.15, 0.15,-0.15,-0.15, 0.15, 0.15,   0, 0];
 line(x2,y2,'Color',dc,'Tag',mydrawimptag)
 text(a+s*0.4,b-s*0.5,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawimptag)
 text(a+s*0.4,b-s*0.2,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','center','VerticalAlignment','top','Tag',mydrawimptag)
else
 x = g + s*[      0,   0, 0.15, 0.15,-0.15,-0.15, 0.15, 0.15,   0, 0];
 y = h + s*[(d-h)/s, 0.1, 0.10, 0.70, 0.70, 0.10, 0.10, 0.70, 0.7, (f-h)/s];
 line(x,y,'Color',dc,'Tag',mydrawimptag)
 text(g+s*0.25,h+s*0.4,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','top','Tag',mydrawimptag)
 text(g+s*0.25,h+s*0.4,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawimptag)
end
