function mydrawotatag = drawota(c,d,f,n,t,p,s,F,dc)
% drawota.m  DRAW OTA
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 

mydrawotatag  = ['drawotax' num2str(c) 'y' num2str(d) 'f' num2str(f) 'p' num2str(p)];

if (p == 0)|(p == 1)
  a=(f+c)/2-0.4*s;
  b=d;
  g=c;
else
  a=(f+c)/2+0.4*s;
  b=d;
  g=c;
end

if p == 0
 x1 = a + s*[0.55, 0.55, 0.25, 0.25, 0.55, 0.55, (f-a)/s];
 y1 = b + s*[   0, 0.15, 0.30, -0.3,-0.15,    0,  0];
 x2 = a + s*[(c-a)/s, 0.25];  y2 = b + s*[  0.2, 0.2];
 x3 = a + s*[(c-a)/s, 0.25];  y3 = b + s*[ -0.2,-0.2];
 x4 = a + s*[ 0.28, 0.38];   y4 = b + s*[-0.15,-0.15];
 x5 = a + s*[ 0.28, 0.38];   y5 = b + s*[ 0.15, 0.15];
 x6 = a + s*[ 0.33, 0.33];   y6 = b + s*[ 0.20, 0.1];
 line(x1,y1,'Color',dc,'Tag',mydrawotatag);  line(x2,y2,'Color',dc,'Tag',mydrawotatag);  line(x3,y3,'Color',dc,'Tag',mydrawotatag);
 line(x4,y4,'Color',dc,'Tag',mydrawotatag);  line(x5,y5,'Color',dc,'Tag',mydrawotatag);  line(x6,y6,'Color',dc,'Tag',mydrawotatag);
 text(a+s*0.4,b+s*0.45,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawotatag)
 text(a+s*0.4,b+s*0.25,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawotatag)
elseif p == 1
 x1 = a + s*[0.55, 0.55, 0.25, 0.25, 0.55, 0.55, (f-a)/s];
 y1 = b + s*[   0, 0.15, 0.30, -0.3,-0.15,    0,  0];
 x2 = a + s*[(c-a)/s, 0.25];  y2 = b + s*[  0.2, 0.2];
 x3 = a + s*[(c-a)/s, 0.25];  y3 = b + s*[ -0.2,-0.2];
 x4 = a + s*[ 0.28, 0.38];   y4 = b + s*[-0.15,-0.15];
 x5 = a + s*[ 0.28, 0.38];   y5 = b + s*[ 0.15, 0.15];
 x6 = a + s*[ 0.33, 0.33];   y6 = b + s*[-0.20,-0.1];
 line(x1,y1,'Color',dc,'Tag',mydrawotatag);  line(x2,y2,'Color',dc,'Tag',mydrawotatag);  line(x3,y3,'Color',dc,'Tag',mydrawotatag);
 line(x4,y4,'Color',dc,'Tag',mydrawotatag);  line(x5,y5,'Color',dc,'Tag',mydrawotatag);  line(x6,y6,'Color',dc,'Tag',mydrawotatag);
 text(a+s*0.4,b+s*0.45,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawotatag)
 text(a+s*0.4,b+s*0.25,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','left','VerticalAlignment','bottom','Tag',mydrawotatag)
elseif p == 2
 x1 = a - s*[0.55, 0.55, 0.25, 0.25, 0.55, 0.55, -(c-a)/s];
 y1 = b + s*[   0, 0.15, 0.30,-0.30,-0.15,    0, 0];
 x2 = a + s*[(f-a)/s, -0.25];  y2 = b + s*[  0.2, 0.2];
 x3 = a + s*[(f-a)/s, -0.25];  y3 = b + s*[ -0.2,-0.2];
 x4 = a - s*[ 0.28, 0.38];   y4 = b + s*[-0.15,-0.15];
 x5 = a - s*[ 0.28, 0.38];   y5 = b + s*[ 0.15, 0.15];
 x6 = a - s*[ 0.33, 0.33];   y6 = b + s*[ 0.20, 0.1];
 line(x1,y1,'Color',dc,'Tag',mydrawotatag);  line(x2,y2,'Color',dc,'Tag',mydrawotatag);  line(x3,y3,'Color',dc,'Tag',mydrawotatag);
 line(x4,y4,'Color',dc,'Tag',mydrawotatag);  line(x5,y5,'Color',dc,'Tag',mydrawotatag);  line(x6,y6,'Color',dc,'Tag',mydrawotatag);
 text(a-s*0.4,b+s*0.45,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawotatag)
 text(a-s*0.4,b+s*0.25,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawotatag)
else
 x1 = a - s*[0.55, 0.55, 0.25, 0.25, 0.55, 0.55, -(c-a)/s];
 y1 = b + s*[   0, 0.15, 0.30,-0.30,-0.15,    0, 0];
 x2 = a + s*[(f-a)/s, -0.25];  y2 = b + s*[  0.2, 0.2];
 x3 = a + s*[(f-a)/s, -0.25];  y3 = b + s*[ -0.2,-0.2];
 x4 = a - s*[ 0.28, 0.38];   y4 = b + s*[-0.15,-0.15];
 x5 = a - s*[ 0.28, 0.38];   y5 = b + s*[ 0.15, 0.15];
 x6 = a - s*[ 0.33, 0.33];   y6 = b + s*[-0.20,-0.1];
 line(x1,y1,'Color',dc,'Tag',mydrawotatag);  line(x2,y2,'Color',dc,'Tag',mydrawotatag);  line(x3,y3,'Color',dc,'Tag',mydrawotatag);
 line(x4,y4,'Color',dc,'Tag',mydrawotatag);  line(x5,y5,'Color',dc,'Tag',mydrawotatag);  line(x6,y6,'Color',dc,'Tag',mydrawotatag);
 text(a-s*0.4,b+s*0.45,n,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawotatag)
 text(a-s*0.4,b+s*0.25,t,'FontName','Times','FontSize',F,...
   'HorizontalAlignment','right','VerticalAlignment','bottom','Tag',mydrawotatag)
end
