function mypolylinetag = drawpoly(varargin)
% drawpoly.m  DRAW POLY-LINE
% Authors: Prof. Dr Miroslav D. Lutovac, Prof. Dr Dejan V. Tosic
% lutovac@kondor.etf.bg.ac.yu    http://kondor.etf.bg.ac.yu/~lutovac/
% tosic@galeb.etf.bg.ac.yu       http://www.rcub.bg.ac.yu/~tosicde/
% $Revision: 2.8 $  $Date: 2005/03/04$
% Copyright 1999-2005 Miroslav D. Lutovac and Dejan V. Tosic
% This file is part of DrawFilt.
% DrawFilt is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% any later version.
% DrawFilt is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% You should have received a copy of the GNU General Public License
% along with DrawFilt; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
% DrawFilt is distributed with the GNU General Public License.
% This licence is contained in the file LICENCE.TXT.
% References:
% Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
% Filter Design for Signal Processing Using MATLAB and Mathematica
% Prentice Hall, ISBN 0-201-36130-2 
%                                     
% argument               1, 2, 3,         4,         5,         6,          7,         
% function dr = drawpoly(X, Y, polylinestyle, polylinewidth, polylinecolor, polymarkertype, polymarkersizef)

narginmydraw = length(varargin);

if narginmydraw == 7
    polymarkersizef = varargin{7};
    polymarkertype  = varargin{6};
    polylinecolor   = varargin{5};
    polylinewidth   = varargin{4};
    polylinestyle   = varargin{3};
    y               = varargin{2};
    x               = varargin{1};
    if (length(varargin{1}) < 2)|(length(varargin{1}) ~= length(varargin{2}))
        disp('Warning: number of input arguments should be 7, for example:')
        disp('drawpoly([x1 x2], [y1 y2], polylinestyle, polylinewidth, polylinecolor, polymarkertype, polymarkersizef)')
        return
    end
else
    disp('Warning: number of input arguments should be 7, for example:')
    disp('drawpoly([x1 x2], [y1 y2], polylinestyle, polylinewidth, polylinecolor, polymarkertype, polymarkersizef)')
    drawdemopoly
    return
end

if (x == y)
    disp('Error using draw: second point should be different from first point');
    return
end

mypolylinetag = ['drawpolylinex' num2str(x) 'y' num2str(y)];

line(x,y,'LineStyle',polylinestyle,'LineWidth',polylinewidth,'Color',polylinecolor,...
     'Marker',polymarkertype,'MarkerSize',polymarkersizef,'Tag',mypolylinetag);

function drdrawdemopoly = drawdemopoly
figure
drawpoly([1 2 3], [3 4 2], '--', 2, 'b', 'o', 8)
drawpoly([4 5 6], [3 4 2], '--', 2, 'r', 's', 10)
axis('equal')
axis('off')
