% Example causal sequence
% Course: Analog and Digital Filter Design
% Lecture: Review Signals
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2004 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2004/11/29$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc
set(0,'DefaultLineLineWidth',2)

B = 0.94; a = 0.1; f = 0.32;
k = -10:1:20;
x = (B.^k).*cos(2*pi*f*k);
u = (k>=0);
ux = x.*u;

subplot(3,1,1)
stem(k,u,'g')
ylabel('u_k','FontSize',14)
axis([k(1) k(end) -2 2])

subplot(3,1,2)
stem(k,x,'b')
ylabel('x_k','FontSize',14)

subplot(3,1,3)
stem(k,ux,'r')
ylabel('x_k u_k','FontSize',14)
xlabel('k')
axis([k(1) k(end) -2 2])
