% Example Frequency response in z-domain
% Course: Analog and Digital Filter Design
% Lecture: Transfer function
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/01/28$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

B = [0.0093 -0.0123 0.0232 -0.0172 0.0233 -0.0124 0.0094]
A = [1 -4.312 8.5888 -9.8704 6.8602 -2.7272 0.4865]
freqz(B,A)

figure
zplane(B,A)
legend('zeros','poles')

disp('tf2zpk convert transfer function to zero-pole-gain form')
[z,p,k] = tf2zpk(B,A)

disp('tf2sos convert transfer function to second-order sections')
sos = tf2sos(B,A)
