% Example singly terminated ladder realization with complex zeros
% Course: Analog and Digital Filter Design
% Lecture: RLC realizations
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% Add DrawFilt to the MATLAB path
path(path,'C:\afd\DrawFilt')

disp('Singly Terminated Ladder Realization with Complex Zeros');

num = [0.0180551694, 0, 0.211322895, 0, 0.516482304];
den = [1, 1.72650359, 2.7987296, 2.47783111, 1.57131579, 0.516477923];
disp('Transfer function numerator = '); disp(num);
disp('Transfer function denominator = '); disp(den);

[y22num, y22den] = y22FromTransferFunction(num,den);
disp('y22 numerator = '); disp(y22num);
disp('y22 denominator = '); disp(y22den);

elementValues = y22ZeroShiftingElements(num,den);

subplot(2,1,1)
draw_y22_1b
subplot(2,1,2)
draw_rlc_1tb

% Verification
Ro = 1;

L1 = elementValues(1);
L2 = elementValues(2);
C2 = elementValues(3);
L3 = elementValues(4);
L4 = elementValues(5);
C4 = elementValues(6);
L5 = elementValues(7);

numH = [C2*C4*L2*L4*Ro, 0, (C2*L2+C4*L4)*Ro, 0, Ro];

denH = [C2*C4*L1*L3*L4+C2*C4*L1*L3*L5+C2*C4*L1*L4*L5+C2*C4*L2*L4*L5+C2*C4*L1*L2*(L4+L5)+C2*C4*L2*L3*(L4+L5), ...
 C2*C4*L3*L4*Ro+C2*C4*L3*L5*Ro+C2*C4*L4*L5*Ro+C2*C4*L2*(L4+L5)*Ro, ...
 C2*L1*L2+C2*L1*L3+C2*L2*L3+C2*L1*L5+C2*L2*L5+C4*L4*L5+C4*L1*(L4+L5)+C4*L3*(L4+L5), ...
 C2*L2*Ro+C2*L3*Ro+C2*L5*Ro+C4*(L4+L5)*Ro, L1+L3+L5, Ro];

numH = numH/denH(1);
denH = denH/denH(1);

disp('Realized H(S) numerator = '); disp(numH);
disp('Realized H(S) denominator = '); disp(denH);
