% [ev,od] = polynomialEvenOddParts(a)
% returns polynomial even and odd parts
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function [ev,od] = polynomialEvenOddParts(a)

n = length(a); 

if n == 2*fix(n/2)
  od = a;
  od(2:2:end) = 0;
  ev = a(2:n);
  ev(2:2:end) = 0;
else
  ev = a;
  ev(2:2:end) = 0;
  od = a(2:n);
  od(2:2:end) = 0;
end
