function ds = afdds(speck)

% afdds.m  AFD design space
%          ds = {ds(nmin), ds(nmin+1), ..., ds(nmax)}
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac
%  calls:
%% afdnell.m, afdncheb.m, afddsi.m

Fp = speck(1);
Fs = speck(2);
Kp = speck(3);
Ks = speck(4);

nmin = afdnell(Fp,Fs,Kp,Ks);
ncheb = afdncheb(Fp,Fs,Kp,Ks);
nmax = min([2*nmin,ncheb-1]);

if nmax < nmin
   nmax = nmin;
end

for n = nmin:nmax
  ds(n-nmin+1,:) = afddsi(n,speck);
end
