function L = afdl(n,a)

% afdl.m  AFD discrimination factor L(n,ksi)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac
%  calls:
%% afdxna.m, 

X = afdxna(n,a);

if abs(n-2*fix(n/2)) == 0
  L = (1/a^n);
  for i=1:n/2
    L = L * ((a^2 - X(i)^2)^2)/((1 - X(i)^2)^2);
  end
else
  L = (1/a^(n-2));
  for i=1:(n-1)/2
    L =L * ((a^2 - X(i)^2)^2) /((1 - X(i)^2)^2);
  end
end
