% afdsdemo.m  AFDS demo specification (script)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

speca = [3.000,  3.225,  0.2,   40];

dstable = ...
[8  1.0428  1.0832  7.5786e-2   0.21709  2.9772  3.0925
 9  1.0220  1.0981  1.8469e-2   0.21709  2.9370  3.1556
10  1.0114  1.1201  3.6867e-3   0.21709  2.8791  3.1888
11  1.0059  1.1517  5.7868e-4   0.21709  2.8002  3.2062
12  1.0030  1.1966  6.7599e-5   0.21709  2.6951  3.2152
13  1.0016  1.2616  5.3913e-6   0.21709  2.5563  3.2199
14  1.0008  1.3595  2.5331e-7   0.21709  2.3722  3.2224
15  1.0004  1.5191  5.2851e-9   0.21709  2.1229  3.2236
16  1.0002  1.8222  2.5187e-11  0.21709  1.7698  3.2243];

Nmin = min(dstable(:,1));
Nmax = max(dstable(:,1));
Nlength = length(dstable(:,1));
Nindex = 0;
Xmin = min(dstable(:,2));
Xmax = max(dstable(:,3));
Emin = min(dstable(:,4));
Emax = max(dstable(:,5));
FPmin = min(dstable(:,6));
FPmax = max(dstable(:,7));

Xmin1 = dstable(1,2);
Xmax1 = dstable(1,3);
Emin1 = dstable(1,4);
Emax1 = dstable(1,5);
FPmin1 = dstable(1,6);
FPmax1 = dstable(1,7);

cubeaxis = [1, Xmax*1.01, 0, Emax*1.01, FPmin*0.99, FPmax*1.01];
caseaxis = [Xmin1*0.99, Xmax1, 0, Emax1*1.01, FPmin1, FPmax1];

initview = [-40,30];
cubeview = initview;
caseview = [-20 40];

delete(gca);
axis off;
text(0,0.9, 'Demo lowpass attenuation limits specification')
text(0,0.8, ['Fpass = ', num2str(speca(1)), ' Hz']);
text(0,0.7, ['Fstop = ', num2str(speca(2)), ' Hz']);
text(0,0.6, ['Apass = ', num2str(speca(3)), ' dB']);
text(0,0.5, ['Astop = ', num2str(speca(4)), ' dB']);
text(0,0.4, 'Fpass = passband edge frequency in Hz');
text(0,0.3, 'Fstop = stopband edge frequency in Hz')
text(0,0.2, 'Apass = maximum passband attenuation in dB')
text(0,0.1, 'Astop = minimum stopband attenuation in dB')
