function afdstabl(dstable)

% afdstabl.m  AFDS table
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

kmax = length(dstable(:,1));
imax = length(dstable(1,:));

disp('Design Space')
disp(['order', ...
      '      selectivity range', ...
      '         ripple range', ...
      '          fp-frequency range (Hz)'])
for k=1:length(dstable(:,1))
  disp([sprintf('%3u',   dstable(k,1)),...
        sprintf('%13.6g',dstable(k,2:imax))])
end
