% afdsuser.m  AFDS user specification (script)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

if exist('userspec.dat')==2
 load userspec.dat;
 speca = userspec;
else
 error('AFDS ERROR in filter specification: No userspec.dat file.')
end

if length(speca)~=4
 error('AFDS ERROR in filter specification: Insufficient data.')
end

if any(speca-abs(speca))
 error('AFDS ERROR in filter specification: Negative data.')
end

if speca(1)>=speca(2)
 error('AFDS ERROR in lowpass spec: Fpass >= Fstop.')
end

if speca(3)>=speca(4)
 error('AFDS ERROR in lowpass spec: Apass >= Astop.')
end

delete(gca);
axis off;

text(0,0.9, 'User lowpass attenuation limits specification')
text(0,0.8, ['Fpass = ', num2str(speca(1)), ' Hz']);
text(0,0.7, ['Fstop = ', num2str(speca(2)), ' Hz']);
text(0,0.6, ['Apass = ', num2str(speca(3)), ' dB']);
text(0,0.5, ['Astop = ', num2str(speca(4)), ' dB']);
text(0,0.4, 'Fpass = passband edge frequency in Hz');
text(0,0.3, 'Fstop = stopband edge frequency in Hz')
text(0,0.2, 'Apass = maximum passband attenuation in dB')
text(0,0.1, 'Astop = minimum stopband attenuation in dB')
