function h = afdswire(Xmin,Xmax,Ymin,Ymax,Zmin,Zmax,wirecolor)

% afdswire.m  AFDS wire model cuboid
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

if nargin<6
 error('AFDS ERROR: Inssuficiant data for AFDSWIRE.');
elseif nargin==6
 wirecolor = 'b';
end

X1 = [Xmin Xmax Xmax Xmin Xmin];
Y1 = [Ymin Ymin Ymax Ymax Ymin];
Z1 = [Zmin Zmin Zmin Zmin Zmin];
C1 = wirecolor;

X2 = [Xmin Xmax Xmax Xmin Xmin];
Y2 = [Ymin Ymin Ymax Ymax Ymin];
Z2 = [Zmax Zmax Zmax Zmax Zmax];
C2 = wirecolor;

X3 = [Xmin Xmax Xmax Xmin Xmin];
Y3 = [Ymin Ymin Ymin Ymin Ymin];
Z3 = [Zmin Zmin Zmax Zmax Zmin];
C3 = wirecolor;

X4 = [Xmin Xmax Xmax Xmin Xmin];
Y4 = [Ymax Ymax Ymax Ymax Ymax];
Z4 = [Zmin Zmin Zmax Zmax Zmin];
C4 = wirecolor;

X5 = [Xmin Xmin Xmin Xmin Xmin];
Y5 = [Ymin Ymax Ymax Ymin Ymin];
Z5 = [Zmin Zmin Zmax Zmax Zmin];
C5 = wirecolor;

X6 = [Xmax Xmax Xmax Xmax Xmax];
Y6 = [Ymin Ymax Ymax Ymin Ymin];
Z6 = [Zmin Zmin Zmax Zmax Zmin];
C6 = wirecolor;

h = plot3(X1,Y1,Z1,C1, X2,Y2,Z2,C2, X3,Y3,Z3,C3, ...
          X4,Y4,Z4,C4, X5,Y5,Z5,C5, X6,Y6,Z6,C6);
