function amax = afdxmax(n, Fp, Fs, Kp, Ks)

% afdxmax.m  AFD maximum selectivity factor
%            ksimax(n)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

nxkskp = [n Fs/Fp Ks Kp];
global AFD_n_x_Ks_Kp;
AFD_n_x_Ks_Kp = nxkskp;

mm = fminsearch('afdrx',sqrt(Fs/Fp-1));
amax = 1+mm^2;
