function xmin = afdxmin(n, Kp, Ks)

% afdxmin.m  AFD minimum selectivity factor
%            ksimin(n)
%
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.1 $  $Date: 2005/02/27 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac

%  calls:
%% afdqk.m

terms=9;
L = Ks/Kp;
qL = afdqk(1/L)^(1/n);
m = 1:terms;
num = 1 + 2*sum((-ones(size(m))).^m.*(qL*ones(size(m))).^(m.^2));
den = 1 + 2*sum((qL*ones(size(m))).^(m.^2));
xmin = 1/sqrt(1 - (num/den)^4);
