% AFDDINFO.M  AFD Design INFO (script)
%   
%          Advanced Analog Filter Design - AFDesign
%   
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac, 1999/02/21
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.23 $  $Date: 2005/01/19 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac
%
                         
% This file is part of AFDesign toolbox for MATLAB.
% Refer to the file LICENSE.TXT for full details.
%                        
% AFDesign version 2.3, Copyright (c) 1999-2005 D. Tosic and M. Lutovac
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; see LICENSE.TXT for details.
%                       
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%                       
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc.,  59 Temple Place,  Suite 330,  Boston,
% MA  02111-1307  USA,  http://www.fsf.org/

%% calls:
%% afdqfmax.m

if desnumb==0

 disp('AFD WARNING: No design has been performed.');

else

 format compact
 disp(' ---------------------------------------------------');
 disp([' Design ', destype, ...
       ' summary for spec ', filname(filnumb,:)]);

 format short e; 
 disp(speca(1:4));
 if filnumb==3 | filnumb==4
  disp(speca(5:7));
 end

 format long e;
 disp([' ORDER ............  nD = ', num2str(nD)]);
 disp([' SELECTIVITY factor  aD = ', num2str(aD)]);
 disp([' RIPPLE factor ....  eD = ', num2str(eD)]);
 disp([' fp-FREQUENCY ..... fpD = ', num2str(fpD)]);

 disp(' NUMERATOR and DENOMINATOR coefficients numD, denD =');
 if length(numD)==length(denD)
  disp([numD;denD]');
 elseif length(numD)==length(denD)-1
  disp(['                              ',num2str(denD(1),16)]);
  disp([numD;denD(2:length(denD))]');
 end

 disp([' FILTER order = ', num2str(length(denD)-1), ', ', ...
       'MAX Quality Factor, Qmax = ', num2str(afdqfmax(denD))]);
 disp([' ', num2str(eseconds), ' seconds.', blanks(4), ...
       'Last coefficient is the free term.']);

end
