% dfdd2.m  BUTTON: AFD DESIGN D2
%   
%          Advanced Digital Filter Design - AFDesign
%   
%   Authors: Dejan V. Tosic, Miroslav D. Lutovac, 1999/02/21
%   tosic@galeb.etf.bg.ac.yu   http://www.rcub.bg.ac.yu/~tosicde/
%   lutovac@kondor.etf.bg.ac.yu    http://galeb.etf.bg.ac.yu/~lutovac/
%   Copyright (c) 1999-2005 by Tosic & Lutovac
%   $Revision: 1.23 $  $Date: 2005/01/19 $
%   
%   References:
%   Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%        Filter Design for Signal Processing
%           Using MATLAB and Mathematica
%        Prentice Hall - ISBN 0-201-36130-2 
%         http://www.prenhall.com/lutovac
%
                         
% This file is part of AFDdesign toolbox for MATLAB.
% Refer to the file LICENSE.TXT for full details.
%                        
% AFDesign version 2.3, Copyright (c) 1999-2005 D. Tosic and M. Lutovac
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; see LICENSE.TXT for details.
%                       
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%                       
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc.,  59 Temple Place,  Suite 330,  Boston,
% MA  02111-1307  USA,  http://www.fsf.org/

%% calls:
%% dadesign.m, dfddemo.m, dfdopen.m, dfdview.m, dfdedit.m
%% dfdplot.m, dfdpass.m, dfdtran.m, dfdstop.m, dfdzoom.m
%% dfdd1.m, dfdd2.m, dfdd3a.m, dfdd3b.m, dfdd4a.m, dfdd4b.m
%% dfdd5.m, dfd2d5.m, dfd3d5.m, 

tstart = clock;
[numD,denD,nD,aD,eD,fpD] = dfdd2(speck,ninc,filtype);
desnumb=2;
destype='D2';
eseconds=etime(clock,tstart);
dfddinfo;
clf;
moreaxis=dfdplot(numD,denD,speca,filnumb,moreaxis,'D2');
Dtype = 'D2';
sizespeca = length(speca);
if sizespeca==4
  title([sprintf('%s : Sa= %9.6f %9.6f %9.5f dB %9.1d dB',Dtype, speca)],'FontSize',9);
elseif sizespeca==7
  if speca(6)<3
    title([sprintf('%s : Sa= %9.6f %9.6f %9.6f %9.6f %5.1d dB %9.5f dB %5.1d dB',Dtype,speca)],'FontSize',7);
  elseif (speca(5)+speca(5))<6
    title([sprintf('%s : Sa= %9.6f %9.6f %9.6f %9.6f %9.5f dB %9.1d dB %9.5f dB',Dtype,speca)],'FontSize',7);
  else
    title([sprintf('%s : Sa= %9.6f %9.6f %9.6f %9.6f %9.1d dB %9.1d dB %9.1d dB',Dtype,speca)],'FontSize',7);
  end
else
  title([sprintf('%s : Sa= %9.6f %9.6f %9.1d dB %9.1d dB',Dtype, speca)],'FontSize',9);
end
