% [L2, C2, numZ3, denZ3] = extractBiquad[num, den, z)
% extract biquad term from impedanse z=num/den
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/02/20$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function [L2, C2, numZ3, denZ3] = extractBiquad(num, den, z)

trinom = [1, 0, abs(z)^2];
[q, r] = polynomialDivide(num, trinom);
%[qDec, rDec] = deconv(num, trinom)
[z polynomialValue(q,z) polynomialValue(den,z)];
L2 = z*polynomialValue(q,z)/polynomialValue(den,z);
C2 = -1/(L2*z^2);

numY2 = den;
denY2 = num;

numY3long = numY2 - [q/L2, 0];
[numY3, r] = polynomialDivide(numY3long, trinom); 
denY3 = q;

numZ3 = denY3;
denZ3 = numY3;
