% (q,r) = polynomialDivide(num, den)
% divides num by den and returns quotient and remainder
% Authors: Dejan V. Tosic, Miroslav D. Lutovac
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.02 $  $Date: 2005/03/03$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

function [q,r] = polynomialDivide(num, den)

n = length(num); 
d = length(den); 

if n < d
  q = []; 
  r = num;
  return;
end

num1 = num;
q = [];

for i = 1:(n-d+1)
   [K,r] = polynomialDivideStep(num1,den);
   q = [q, K];
   num1 = r;
end
