% Example response of a discrete-time system
% Course: Analog and Digital Filter Design
% Lecture: Finite precision effects
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/04/12$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% compute the filter coefficients
N = 22;             % Filter order
F = [0 0.4 0.5 1];  % Frequency vector
A = [1 1 0 0];      % Magnitude vector
W = [1 5];          % Weight vector
[b,err,res] = firgr(N,F,A,W);
hfvt = fvtool(b);

% % create fixed-point direct-form FIR filter
H = dfilt.dffir(b);
set(H,'Arithmetic','fixed');
H1 = copy(H);
nBits1 = 8;
set(H1,'CoeffWordLength',nBits1); % Use nBits1 bits
set(hfvt, 'Filters', [H, H1],'ShowReference','off');
legend(hfvt,'Reference filter',[num2str(nBits1) ' bits wordlength']);
axis([0 1 -80 10]);

% fixed-point filtering; generating test input data
n1 = 1024;
k = 0:n1-1;
f1 = 1/8; f2 = 3/4;
x = sin(2*pi*f1*k) + sin(2*pi*f2*k);
xin = fi(x,true,8,7);

H2 = copy(H1);
set(H2,'ProductMode','KeepMSB','ProductWordLength', 8);
y1 = filter(H1,xin);
y2 = filter(H2,xin);
total_error = norm(double(y1)-double(y2))
max_deviation = norm(double(y1)-double(y2),inf)

X  = 20*log10( abs(fft(x)/(n1/2) ) );
Y1 = 20*log10( abs(fft(y1.data)/(n1/2) ) );
Y2 = 20*log10( abs(fft(y2.data)/(n1/2) ) );
Y12 = 20*log10( abs(fft(y1.data-y2.data)/(n1/2) ) );
nplot = 1:(n1/2+1);

figure, 
subplot(3,1,1)
plot((nplot-1)/(n1/2),X(nplot)), axis([0 1 -60 3]);
ylabel('X (dB)')
subplot(3,1,2)
plot((nplot-1)/(n1/2),Y1(nplot)), axis([0 1 -60 3]);
ylabel('Y (dB)')
subplot(3,1,3)
plot((nplot-1)/(n1/2),Y12(nplot)), axis([0 1 -60 3]);
ylabel('error (dB)')
legend('20 log_{10}|FFT(y_{FLOATING} - y_{FIXED-POINT})|')

xrange = (496:521);
figure, 
subplot(3,1,1)
plot(k(xrange),x(xrange))
ylabel('x')
subplot(3,1,2)
plot(k(xrange),y1.data(xrange),'b',k(xrange),y2.data(xrange),'r')
ylabel('y')
legend('y_{FLOATING}','y_{FIXED-POINT}')
subplot(3,1,3)
plot(k(xrange),y1.data(xrange)-y2.data(xrange))
ylabel('error')

figure, subplot(3,1,1)
dfont = 6;
N = 22;
drawdd1_in(0,0,4,5,dfont,'b');
for ind = 1:N
    drawdd1(2*(ind-1),0,4,5,dfont,ind,'b');
end
drawdd1_out(2*(N-1),0,4,5,dfont,'b');
set(gcf,'Color',[1 1 0.9])

subplot(3,1,2)
[h,w] = freqz(H1.Numerator,1);
M = -20*log10(abs(h));
plot(w/(2*pi),M), axis([0 0.5 -10 80])

subplot(3,2,5)
plot(w/(2*pi),M), axis([0 0.25 -2 2])

subplot(3,2,6)
plot(w/(2*pi),M), axis([0.25 0.5 20 60])

