% Example dead band
% Course: Analog and Digital Filter Design
% Lecture: Finite precision effects
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/04/13$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

b = 10;
a = [1 -0.9];

H = dfilt.df2(b,a);

n = 300;
k = 0:n-1;
x = 0*k; x(1) = 1/4;


H2 = copy(H);
set(H2,'Arithmetic','fixed','CoeffWordLength',12);
set(H2,'ProductMode','KeepMSB','ProductWordLength', 14);

y1 = filter(H, x);
y2 = filter(H2,x);

xrange = (51:n);
figure
plot(k(xrange),y1(xrange),'b',k(xrange),y2.data(xrange),'r')
ylabel('output')
legend('FLOATING','FIXED-POINT')
