% Example response of a discrete-time system
% Course: Analog and Digital Filter Design
% Lecture: Finite precision effects
% Authors: Miroslav D. Lutovac, Dejan V. Tosic
% Email: lutovac@kondor.etf.bg.ac.yu
% Web: http://kondor.etf.bg.ac.yu/~lutovac/
% Copyright (c) 2005 by Lutovac & Tosic
% $Revision: 1.00 $  $Date: 2005/04/13$
% See also: Miroslav D. Lutovac, Dejan V. Tosic, Brian L. Evans
%  Filter Design for Signal Processing Using MATLAB and Mathematica
%  Prentice Hall (c)2001. ISBN 0-201-36130-2

clear all, close all, clc

% compute the filter coefficients
N = 9;         % Filter order
F = 0.5;       % Cutoff frequency 
Ap = 0.01;     % Maximum passband attenuation
As = 40;       % Minimum stopband attenuation
[z,p,k] = ellip(N,Ap,As,F);
[b,a]   = ellip(N,Ap,As,F);

% create fixed-point direct-form FIR filter
H = dfilt.df2(b,a);
hfvt = fvtool(H);
H1 = copy(H);
set(H1,'Arithmetic','fixed','CoeffWordLength',12);

set(hfvt, 'Filters', [H, H1],'ShowReference','off');
legend(hfvt,'Reference filter', '12 bits wordlength');
axis([0 1 -80 10]);

% fixed-point filtering; generating test input data
n1 = 1024;
k = 0:n1-1;
f1 = 1/8; f2 = 340/1024;
Am = 1/4;
x = Am*sin(2*pi*f1*k) + Am*sin(2*pi*f2*k);
xin = fi(x,true,64,63);
%xin2 = zeros(size(xin));
%xin2(1)=1;
%xin = xin2;

H2 = copy(H1);
set(H2,'ProductMode','KeepMSB','ProductWordLength', 14);
y1 = filter(H,xin);
y2 = filter(H2,xin);

X  = 20*log10( abs(fft(x)/(n1/2) ) );
Y1 = 20*log10( abs(fft(y1)/(n1/2) ) );
Y2 = 20*log10( abs(fft(y2.data)/(n1/2) ) );
nplot = 1:(n1/2+1);

figure
subplot(3,1,1)
plot((nplot-1)/(n1/2),X(nplot)), axis([0 1 -80 3]);
ylabel('X (dB)')
subplot(3,1,2)
plot((nplot-1)/(n1/2),Y1(nplot)), axis([0 1 -80 3]);
ylabel('Y_{FLOATING} (dB)')
subplot(3,1,3)
plot((nplot-1)/(n1/2),Y2(nplot)), axis([0 1 -80 3]);
ylabel('Y_{FIXED-POINT} (dB)')

xrange = (701:1000);
figure
subplot(2,1,1)
plot(k(xrange),x(xrange))
ylabel('x')
subplot(2,1,2)
plot(k(xrange),y1(xrange),'b',k(xrange),y2.data(xrange),'r')
ylabel('y')
legend('y_{FLOATING}','y_{FIXED-POINT}')
