/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import screen.Stage;

public abstract class Sprite {
    public Stage stage;
    protected int x;
    protected int y;
    int width;
    int height;
    protected boolean dirty = true;
    Sprite dirtyPartner;

    public Sprite(Stage stage, Point loc) {
        this.stage = stage;
        this.x = loc.x;
        this.y = loc.y;
    }

    public Sprite(Stage stage, int x, int y, int width, int height) {
        this.stage = stage;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setDirtyPartner(Sprite dirtyPartner) {
        this.dirtyPartner = dirtyPartner;
    }

    public void addStage(int theChannel) {
        this.stage.addSprite(this, theChannel);
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public Rectangle bounds() {
        Rectangle rect = new Rectangle(this.x, this.y, this.width, this.height);
        return rect;
    }

    public synchronized boolean inside(int x, int y) {
        return x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
        this.markDirty();
    }

    public void move(Point p) {
        this.move(p.x, p.y);
    }

    public void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.markDirty();
    }

    public void reshape(Rectangle rect) {
        this.reshape(rect.x, rect.y, rect.width, rect.height);
    }

    public synchronized abstract boolean drawAll(Graphics var1);

    public synchronized boolean drawNew(Graphics g) {
        if (this.dirty) {
            boolean result = this.drawAll(g);
            return result;
        }
        return false;
    }

    public final void markDirty() {
        if (this.stage == null) {
            System.out.println("Sprite.markDirty: stage is null with sprite " + this);
        } else {
            this.stage.dirtySprite(this);
        }
        this.dirty = true;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void markClean() {
        this.dirty = false;
    }

    public abstract String toString();

    public void dispose() {
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

