/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import screen.Node;
import screen.Sprite;
import screen.Stage;

public class SpriteComponent
extends Sprite {
    String name;
    Vector nodes = new Vector(4);

    public SpriteComponent(Stage stage, String name, int x, int y, int width, int height) {
        super(stage, new Point(x, y));
        this.width = width;
        this.height = height;
        this.name = name;
    }

    public void addNode(String nodeName, int dX, int dY) {
        Node node = new Node(this.name + ":" + nodeName, this.x + dX, this.y + dY);
        this.nodes.addElement(node);
    }

    public void addStage(int theChannel) {
        super.addStage(theChannel);
        Enumeration e = this.nodes.elements();
        while (e.hasMoreElements()) {
            this.stage.addNode((Node)e.nextElement());
        }
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return false;
    }

    public void dispose() {
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + "[width=" + this.width + ",height=" + this.height + "]";
    }
}

