/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import screen.Sprite;
import screen.Stage;

public class SpriteEditBox
extends Sprite {
    Font font = new Font("Helvetica", 0, 12);
    FontMetrics fontMetrics;
    StringBuffer text;
    String textToString;
    boolean selected = true;
    int value;
    boolean calcOffsets = true;
    boolean centered;
    int xOffset;
    int yOffset;
    Color unselText = Color.black;
    Color unselBG = Color.white;
    Color selText = Color.white;
    Color selBG = Color.black;
    static final int MARGIN = 4;

    public SpriteEditBox(Stage stage, int x, int y, int width, int height, String text, boolean centered) {
        super(stage, x, y, width, height);
        this.text = new StringBuffer(text);
        this.textToString = text;
        this.centered = centered;
    }

    public void setValue(String text) {
        this.text = new StringBuffer(text);
        this.textToString = text;
        this.selected = true;
        this.calcOffsets = true;
        this.markDirty();
    }

    public String getValue() {
        return this.text.toString();
    }

    public void addKey(char key) {
        if (this.selected) {
            this.selected = false;
            this.text.setLength(0);
        }
        if (key == '\b') {
            if (this.text.length() > 0) {
                this.text.setLength(this.text.length() - 1);
            }
        } else if (key >= ' ' && key <= '~') {
            this.text.append(Character.toUpperCase(key));
        }
        this.textToString = this.text.toString();
        if (this.fontMetrics != null && this.fontMetrics.stringWidth(this.textToString) > this.width - 8) {
            this.text.setLength(this.text.length() - 1);
            this.textToString = this.text.toString();
        }
        if (this.centered) {
            this.calcOffsets = true;
        }
        this.markDirty();
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        if (this.calcOffsets) {
            if (this.fontMetrics == null) {
                this.fontMetrics = g.getFontMetrics(this.font);
            }
            this.yOffset = this.height - (this.height - (this.fontMetrics.getAscent() - (1 + this.font.getSize() / 12))) / 2;
            this.xOffset = this.centered ? (this.width - this.fontMetrics.stringWidth(this.textToString)) / 2 : 4;
            this.calcOffsets = false;
        }
        g.setColor(this.selected ? this.selBG : this.unselBG);
        g.fillRect(this.x, this.y, this.width, this.height);
        g.setColor(this.selected ? this.selText : this.unselText);
        g.setFont(this.font);
        g.drawString(this.textToString, this.x + this.xOffset, this.y + this.yOffset);
        return this.dirty;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.textToString + "]";
    }
}

