/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import screen.SpriteComponent;
import screen.Stage;
import screen.TextBox;
import util.CPUTools;

public class SpriteIR
extends SpriteComponent {
    TextBox operatorBox;
    TextBox operandBox;
    Font font = new Font("Helvetica", 0, 12);

    public SpriteIR(Stage stage, int x, int y, int width, int height) {
        super(stage, "IR", x, y, width, height);
        this.addNode("DAT", width / 2, 0);
        this.addNode("DEC", width / 4, height);
        this.addNode("ADD", 3 * width / 4, height);
        this.operatorBox = new TextBox(stage, x, y, width / 2, height, "", "", this.font, false, true);
        this.operandBox = new TextBox(stage, x + width / 2, y, width / 2, height, "", "", this.font, false, true);
    }

    public void setValue(int instruction) {
        int opcodeInt = CPUTools.top8Bits(instruction);
        int operandInt = CPUTools.bottom8Bits(instruction);
        String opcodeString = CPUTools.int16ToOpcode(instruction);
        String operandString = CPUTools.int16ToOperand(instruction);
        this.operatorBox.setText(opcodeString, CPUTools.intToBinString(opcodeInt, 8));
        this.operandBox.setText(operandString, CPUTools.intToBinString(operandInt, 8));
        this.markDirty();
    }

    public void flashOperator() {
        this.operatorBox.flashBG();
        this.markDirty();
    }

    public void flashOperand() {
        this.operandBox.flashBG();
        this.markDirty();
    }

    public void clear() {
        this.operatorBox.setText("", "");
        this.operandBox.setText("", "");
        this.markDirty();
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        this.dirty |= this.operandBox.drawAll(g);
        this.dirty |= this.operatorBox.drawAll(g);
        g.setColor(Color.black);
        g.drawRect(this.x, this.y, this.width, this.height);
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }
}

