/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import screen.Sprite;
import screen.Stage;

public class SpriteLabel
extends Sprite {
    Color textColor = Color.black;
    Color bgColor = Color.lightGray;
    boolean calcOffsets = true;
    int xOffset;
    int yOffset;
    static final int LEFT = 1;
    static final int CENTER = 2;
    static final int RIGHT = 3;
    static final int TOP = 4;
    static final int BOTTOM = 5;
    int horPos;
    int vertPos;
    String text;
    Font font = new Font("Helvetica", 0, 12);

    public SpriteLabel(Stage stage, String text, int x, int y, int width, int height, int horPos, int vertPos) {
        super(stage, x, y, width, height);
        this.text = text;
        this.horPos = horPos;
        this.vertPos = vertPos;
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        g.setPaintMode();
        if (this.calcOffsets) {
            FontMetrics fm = g.getFontMetrics(this.font);
            this.xOffset = this.horPos == 1 ? 0 : (this.horPos == 3 ? this.width - fm.stringWidth(this.text) : (this.width - fm.stringWidth(this.text)) / 2);
            this.yOffset = this.vertPos == 4 ? fm.getAscent() - (1 + this.font.getSize() / 12) : (this.vertPos == 5 ? this.height : this.height - (this.height - (fm.getAscent() - (1 + this.font.getSize() / 12))) / 2);
            this.calcOffsets = false;
        }
        g.setColor(this.bgColor);
        g.fillRect(this.x, this.y, this.width, this.height);
        g.setColor(this.textColor);
        g.setFont(this.font);
        g.drawString(this.text, this.x + this.xOffset, this.y + this.yOffset);
        return this.dirty;
    }

    public String toString() {
        return this.getClass().getName() + "[]";
    }
}

