/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import screen.SpriteComponent;
import screen.Stage;
import util.ColorTools;

public class SpriteMUX
extends SpriteComponent {
    long lineTime;
    long bgTime;
    static final int COLOR_COUNT = 10;
    static final int COLOR_TIME = 100;
    static Color[] lineColors = ColorTools.interpArrayHSB(Color.green, new Color(128, 0, 0), 10);
    static Color[] bgColors = ColorTools.interpArrayHSB(Color.green, new Color(224, 224, 224), 10);
    boolean calcOffsets = true;
    static final String label = "MUX";
    int xOffset;
    int yOffset;
    Font font = new Font("Helvetica", 0, 12);
    Polygon border;
    static final float SLOPE = 2.0f;
    static final int INPUT_DIST = 15;
    boolean showLine = false;
    boolean rightNode;

    public SpriteMUX(Stage stage, int x, int y, int width, int height) {
        super(stage, label, x, y, width, height);
        this.addNode("ADD", 15, 0);
        this.addNode("DAT", width - 15, 0);
        this.addNode("ALU", width / 2, height);
        this.addNode("DEC", (int)((float)height / 2.0f / 2.0f), height / 2);
        this.border = new Polygon();
        this.border.addPoint(x, y);
        this.border.addPoint(x + width, y);
        this.border.addPoint(x + width - (int)((float)height / 2.0f), y + height);
        this.border.addPoint(x + (int)((float)height / 2.0f), y + height);
        this.border.addPoint(x, y);
    }

    public void set(boolean rightNode) {
        this.rightNode = rightNode;
        this.showLine = true;
        this.markDirty();
    }

    public void clear() {
        this.showLine = false;
        this.markDirty();
    }

    public void flashLine() {
        this.lineTime = System.currentTimeMillis();
        this.markDirty();
    }

    public void flashBG() {
        this.bgTime = System.currentTimeMillis();
        this.markDirty();
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        if (this.calcOffsets) {
            FontMetrics fm = g.getFontMetrics(this.font);
            this.xOffset = (this.width - fm.stringWidth(label)) / 2;
            this.yOffset = this.height - (this.height - (fm.getAscent() - (1 + this.font.getSize() / 12))) / 2;
            this.calcOffsets = false;
        }
        this.dirty |= ColorTools.setColor(g, bgColors, this.bgTime);
        g.fillPolygon(this.border);
        g.setColor(Color.black);
        g.drawPolygon(this.border);
        g.setColor(Color.black);
        g.setFont(this.font);
        g.drawString(label, this.x + this.xOffset, this.y + this.yOffset);
        if (this.dirtyPartner != null) {
            this.dirtyPartner.markDirty();
        }
        return this.dirty;
    }
}

