/*
 * Decompiled with CFR 0.152.
 */
package screen;

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import screen.Node;
import screen.Sprite;
import screen.Stage;
import util.ColorTools;

public class SpriteRect
extends Sprite {
    Color bgColor;
    static final int RECT_SIZE = 7;
    boolean framed = false;
    static final int COLOR_COUNT = 10;
    static Color[] bgColors = ColorTools.interpArrayHSB(Color.green, new Color(224, 224, 224), 10);
    long time;

    public SpriteRect(Stage stage, int x, int y, int width, int height) {
        super(stage, new Point(0, 0));
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.framed = true;
    }

    public SpriteRect(Stage stage, Color bgColor, Node horiz, Node vert) {
        super(stage, new Point(0, 0));
        this.bgColor = bgColor;
        int xCenter = horiz.location().x;
        int yCenter = vert.location().y;
        this.x = xCenter - 3;
        this.y = yCenter - 3;
        this.width = 7;
        this.height = 7;
        this.markDirty();
    }

    public boolean inside(int x, int y) {
        return false;
    }

    public void mouseHandle(Event event) {
    }

    public void flash() {
        this.time = System.currentTimeMillis();
        this.markDirty();
    }

    public boolean drawAll(Graphics g) {
        this.markClean();
        g.setPaintMode();
        if (this.bgColor != null) {
            g.setColor(this.bgColor);
        } else {
            this.dirty |= ColorTools.setColor(g, bgColors, this.time);
        }
        g.fillRect(this.x, this.y, this.width, this.height);
        if (this.framed) {
            g.setColor(Color.black);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
        if (this.dirtyPartner != null) {
            this.dirtyPartner.drawAll(g);
        }
        return this.dirty;
    }

    public String toString() {
        return this.getClass().getName() + "[]";
    }
}

