/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Graphics;

public class ColorTools {
    static final int COLOR_TIME = 100;

    private ColorTools() {
    }

    public static Color interpRGB(Color start, Color end, float progress) {
        float startRed = (float)start.getRed() / 255.0f;
        float startGreen = (float)start.getGreen() / 255.0f;
        float startBlue = (float)start.getBlue() / 255.0f;
        float endRed = (float)end.getRed() / 255.0f;
        float endGreen = (float)end.getGreen() / 255.0f;
        float endBlue = (float)end.getBlue() / 255.0f;
        return new Color(ColorTools.interpolate(startRed, endRed, progress, false), ColorTools.interpolate(startGreen, endGreen, progress, false), ColorTools.interpolate(startBlue, endBlue, progress, false));
    }

    public static Color[] interpArrayRGB(Color start, Color end, int count) {
        Color[] result = new Color[count];
        float startRed = (float)start.getRed() / 255.0f;
        float startGreen = (float)start.getGreen() / 255.0f;
        float startBlue = (float)start.getBlue() / 255.0f;
        float endRed = (float)end.getRed() / 255.0f;
        float endGreen = (float)end.getGreen() / 255.0f;
        float endBlue = (float)end.getBlue() / 255.0f;
        int i = 0;
        while (i < count) {
            float progress = (float)i / (float)(count - 1);
            result[i] = new Color(ColorTools.interpolate(startRed, endRed, progress, false), ColorTools.interpolate(startGreen, endGreen, progress, false), ColorTools.interpolate(startBlue, endBlue, progress, false));
            ++i;
        }
        return result;
    }

    public static Color[] interpArrayHSB(Color start, Color end, int count) {
        Color[] result = new Color[count];
        float[] startHSB = Color.RGBtoHSB(start.getRed(), start.getGreen(), start.getBlue(), null);
        float[] endHSB = Color.RGBtoHSB(end.getRed(), end.getGreen(), end.getBlue(), null);
        if (startHSB[2] == 0.0f) {
            startHSB[0] = endHSB[0];
            startHSB[1] = endHSB[1];
        } else if (endHSB[2] == 0.0f) {
            endHSB[0] = startHSB[0];
            endHSB[1] = startHSB[1];
        } else if (startHSB[1] == 0.0f) {
            startHSB[0] = endHSB[0];
        } else if (endHSB[1] == 0.0f) {
            endHSB[0] = startHSB[0];
        }
        int i = 0;
        while (i < count) {
            float progress = (float)i / (float)(count - 1);
            float hue = ColorTools.interpolate(startHSB[0], endHSB[0], progress, true);
            if (hue >= 1.0f) {
                hue = 0.0f;
            }
            float sat = ColorTools.interpolate(startHSB[1], endHSB[1], progress, false);
            float bri = ColorTools.interpolate(startHSB[2], endHSB[2], progress, false);
            result[i] = Color.getHSBColor(hue, sat, bri);
            ++i;
        }
        return result;
    }

    public static boolean setColor(Graphics g, Color[] colors, long time) {
        long index = (System.currentTimeMillis() - time) / 100L;
        if (index >= (long)(colors.length - 1)) {
            g.setColor(colors[colors.length - 1]);
            return false;
        }
        g.setColor(colors[(int)index]);
        return true;
    }

    private static float interpolate(float start, float end, float progress, boolean wrap) {
        float result;
        if (start + 0.5f > end && end + 0.5f > start) {
            wrap = false;
        }
        if (wrap) {
            if (start > end) {
                end += 1.0f;
            } else {
                start += 1.0f;
            }
        }
        if ((result = start + (end - start) * progress) > 1.0f) {
            result -= 1.0f;
        }
        return result;
    }
}

