/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;

public class FFCanvas
extends Canvas {
    Image buf;
    Graphics bufGraphics;
    Dimension bufSize;
    boolean page = false;
    boolean zeroRangeBug = false;
    int pageX;
    int pageY;
    int pageWidth;
    int pageHeight;
    Scrollbar scrollX;
    Scrollbar scrollY;
    FFCanvas partner;

    public void setScrolls(Scrollbar scrollX, Scrollbar scrollY) {
        this.setScrolls(scrollX, scrollY, false);
    }

    public void setScrolls(Scrollbar scrollX, Scrollbar scrollY, boolean zeroRangeBug) {
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.zeroRangeBug = zeroRangeBug;
        this.toScrolls();
    }

    public void setPartner(FFCanvas partner) {
        this.partner = partner;
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.repaint();
    }

    public void pageResize(int pageWidth, int pageHeight) {
        this.page = true;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.toScrolls();
        this.repaint();
    }

    public void pageReshape(int pageX, int pageY, int pageWidth, int pageHeight) {
        this.page = true;
        this.pageX = pageX;
        this.pageY = pageY;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.toScrolls();
        this.repaint();
    }

    public Dimension pageSize() {
        if (this.page) {
            return new Dimension(this.pageWidth, this.pageHeight);
        }
        return this.size();
    }

    public Rectangle pageBounds() {
        if (this.page) {
            return new Rectangle(this.pageX, this.pageY, this.pageWidth, this.pageHeight);
        }
        return new Rectangle(0, 0, this.size().width, this.size().height);
    }

    public void fromScrolls() {
        if (this.scrollX != null) {
            this.pageX = this.scrollX.getValue() < 0 ? 0 : -this.scrollX.getValue();
            if (this.scrollX.getMaximum() > this.pageWidth - this.size().width) {
                this.pageWidth = this.scrollX.getMaximum() + this.size().width;
            }
        }
        if (this.scrollY != null) {
            this.pageY = this.scrollY.getValue() < 0 ? 0 : -this.scrollY.getValue();
            if (this.scrollY.getMaximum() > this.pageHeight - this.size().height) {
                this.pageHeight = this.scrollY.getMaximum() + this.size().height;
            }
        }
        this.repaint();
    }

    public void toScrolls() {
        int minimum = 0;
        if (this.zeroRangeBug) {
            minimum = -1;
        }
        if (this.scrollX != null) {
            this.scrollX.setValues(this.pageX == 0 ? -1 : -this.pageX, this.size().width, minimum, this.pageWidth - this.size().width);
        }
        if (this.scrollY != null) {
            this.scrollY.setValues(this.pageY == 0 ? -1 : -this.pageY, this.size().height, minimum, this.pageHeight - this.size().height);
        }
        if (this.partner != null) {
            this.partner.fromScrolls();
        }
    }

    public synchronized void update(Graphics g) {
        if (g == null) {
            g = this.getGraphics();
        }
        if (g != null) {
            this.paint(g);
        }
    }

    public synchronized void paint(Graphics g) {
        if (this.isVisible()) {
            Graphics drawG;
            int height;
            boolean oldBuffer = true;
            int width = this.page ? this.pageWidth : this.size().width;
            int n = height = this.page ? this.pageHeight : this.size().height;
            if (this.bufSize == null || this.bufGraphics == null || this.buf == null || this.bufSize.width != width || this.bufSize.height != height) {
                oldBuffer = false;
                if (this.bufGraphics != null) {
                    this.bufGraphics.dispose();
                }
                this.bufSize = new Dimension(width, height);
                this.buf = this.createImage(width, height);
                if (this.buf != null) {
                    this.bufGraphics = this.buf.getGraphics();
                }
            }
            if (this.buf == null) {
                drawG = g.create();
                drawG.translate(this.pageX, this.pageY);
            } else {
                drawG = this.bufGraphics;
            }
            if (drawG == null) {
                System.out.println("FFCanvas.paint: ERROR! drawG is null!!!!");
            }
            if (oldBuffer) {
                this.paintNew(drawG);
            } else {
                this.paintAll(drawG);
            }
            if (this.buf != null) {
                if (this.page) {
                    g.drawImage(this.buf, this.pageX, this.pageY, this);
                    return;
                }
                g.drawImage(this.buf, 0, 0, this);
            }
        }
    }

    public void paintNew(Graphics g) {
        this.paintAll(g);
    }

    public void paintAll(Graphics g) {
    }

    public void dispose() {
        if (this.buf != null) {
            this.buf.flush();
            this.buf = null;
        }
        if (this.bufGraphics != null) {
            this.bufGraphics.dispose();
            this.bufGraphics = null;
        }
        this.bufSize = null;
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

