/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import util.ImageButtonGroup;

public class ImageButton
extends Canvas {
    int type;
    String labelOn;
    String labelOff;
    Image imageOn;
    Image imageOff;
    Image imageDisabled;
    boolean enabled = true;
    int imageWidth = -1;
    int imageHeight = -1;
    ImageButtonGroup group;
    public static final int MOMENTARY = 1;
    public static final int TOGGLE = 2;
    public static final int RADIO = 3;
    boolean state = false;
    boolean pressed = false;

    public ImageButton(int type, String labelOn, String labelOff, Image imageOn, Image imageOff, Image imageDisabled, ImageButtonGroup group) {
        this.type = type;
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.imageOn = imageOn;
        this.imageOff = imageOff;
        this.imageDisabled = imageDisabled;
        this.group = group;
        this.imageWidth = imageOn.getWidth(this);
        this.imageHeight = imageOn.getHeight(this);
        if (this.imageWidth != -1 && this.imageHeight != -1) {
            this.resize(this.imageWidth, this.imageHeight);
        }
    }

    public ImageButton(String label, Image imageOn, Image imageOff, Image imageDisabled) {
        this(1, label, null, imageOn, imageOff, imageDisabled, null);
    }

    public ImageButton(String labelOn, String labelOff, Image imageOn, Image imageOff, Image imageDisabled) {
        this(2, labelOn, labelOff, imageOn, imageOff, imageDisabled, null);
    }

    public ImageButton(String label, Image imageOn, Image imageOff, Image imageDisabled, ImageButtonGroup group) {
        this(3, label, null, imageOn, imageOff, imageDisabled, group);
    }

    public void enable(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            super.enable(enabled);
            this.paint(null);
        }
    }

    public void move(int x, int y) {
        this.reshape(x, y, this.size().width, this.size().height);
    }

    public void resize(int width, int height) {
        Rectangle bounds = this.bounds();
        this.reshape(bounds.x, bounds.y, width, height);
    }

    public void resize(Dimension d) {
        Rectangle bounds = this.bounds();
        this.reshape(bounds.x, bounds.y, d.width, d.height);
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        boolean resized;
        Rectangle bounds = this.bounds();
        boolean bl = resized = bounds.width != width || bounds.height != height;
        if (resized || bounds.x != x || bounds.y != y) {
            super.reshape(x, y, width, height);
            this.paint(null);
        }
    }

    public Dimension preferredSize() {
        Rectangle bounds = this.bounds();
        return new Dimension(bounds.width, bounds.height);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void setState(boolean state) {
        switch (this.type) {
            case 2: {
                this.setStateInternal(state);
                this.paint(null);
                return;
            }
            case 3: {
                if (this.group == null) break;
                if (state) {
                    this.group.setCurrent(this);
                } else if (this.state) {
                    this.group.setCurrent(null);
                }
                this.paint(null);
                return;
            }
        }
    }

    public boolean getState() {
        return this.state;
    }

    void setStateInternal(boolean state) {
        this.state = state;
        this.paint(null);
    }

    public boolean mouseMove(Event evt, int x, int y) {
        if (!this.enabled) {
            return false;
        }
        if (this.type == 1) {
            this.pressed = false;
        }
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (!this.enabled) {
            return false;
        }
        switch (this.type) {
            case 1: {
                this.pressed = true;
                this.setStateInternal(true);
                break;
            }
            case 2: {
                this.setStateInternal(!this.state);
                this.postActionEvent(evt, this.state);
                break;
            }
            case 3: {
                if (this.group == null || this.group.getCurrent() == this) break;
                this.group.setCurrent(this);
                this.postActionEvent(evt, this.state);
                break;
            }
        }
        return true;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        if (!this.enabled) {
            return false;
        }
        if (this.type == 1 && this.pressed) {
            boolean newState = this.mouseEventInside(evt.x, evt.y);
            if (this.state != newState) {
                this.setStateInternal(newState);
            }
            return true;
        }
        return false;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        if (!this.enabled) {
            return false;
        }
        if (this.type == 1) {
            if (this.pressed && this.state) {
                this.setStateInternal(false);
            }
            return true;
        }
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        if (!this.enabled) {
            return false;
        }
        if (this.type == 1) {
            if (this.pressed && !this.state) {
                this.setStateInternal(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (!this.enabled) {
            return false;
        }
        if (this.type == 1) {
            this.setStateInternal(false);
            if (this.pressed && this.mouseEventInside(evt.x, evt.y)) {
                this.postActionEvent(evt, true);
            }
            this.pressed = false;
            return true;
        }
        return false;
    }

    public String getLabel() {
        if (this.type == 1) {
            return this.labelOn;
        }
        if (this.state) {
            return this.labelOn;
        }
        return this.labelOff;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (g == null) {
            g = this.getGraphics();
        }
        if (g != null) {
            Dimension d = this.size();
            g.drawImage(this.enabled ? (this.state ? this.imageOn : this.imageOff) : this.imageDisabled, 0, 0, d.width, d.height, this);
        }
    }

    protected String paramString() {
        return super.paramString() + ",state=" + this.state + ",labelOn=" + this.labelOn + ",labelOff=" + this.labelOff + ",imageOn=" + this.imageOn + ",imageOff=" + this.imageOff + ",imageWidth=" + this.imageWidth + ",imageHeight=" + this.imageHeight + ",group=" + this.group;
    }

    public boolean imageUpdate(Image image, int flags, int x, int y, int w, int h) {
        boolean paint = false;
        boolean gotDimension = false;
        if (this.imageWidth == -1 && (flags & 1) != 0) {
            this.imageWidth = w;
            gotDimension = true;
        }
        if (this.imageHeight == -1 && (flags & 2) != 0) {
            this.imageHeight = h;
            gotDimension = true;
        }
        if (gotDimension && this.imageWidth != -1 && this.imageHeight != -1) {
            this.resize(this.imageWidth, this.imageHeight);
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().layout();
            }
            paint = true;
        }
        if ((flags & 0x28) != 0) {
            paint = true;
        }
        if (paint) {
            this.paint(null);
        }
        return (flags & 0xA0) == 0;
    }

    private void postActionEvent(Event evt, boolean eventState) {
        Event event = new Event(this, evt.when, 1001, evt.x, evt.y, evt.key, evt.modifiers, eventState ? this.labelOn : this.labelOff);
        if (this.getParent() != null) {
            this.getParent().postEvent(event);
        }
    }

    private boolean mouseEventInside(int x, int y) {
        Dimension d = this.size();
        return x >= 0 && x < d.width && y >= 0 && y < d.height;
    }
}

