/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Hashtable;

public class ImageLoader {
    Applet applet;
    Hashtable table = new Hashtable(40);

    public ImageLoader(Applet applet, String[] imageList) {
        this.applet = applet;
        Image offScreenBuffer = applet.createImage(1, 1);
        int x = 0;
        while (x < imageList.length) {
            String imageName = imageList[x];
            Image theImage = applet.getImage(applet.getCodeBase(), "images/" + imageName + ".GIF");
            this.table.put(imageName, theImage);
            MediaTracker tracker = new MediaTracker(applet);
            tracker.addImage(theImage, x);
            theImage.getHeight(null);
            applet.showStatus("ImageLoader: Caching image: " + imageName + ".");
            try {
                tracker.waitForID(x);
            }
            catch (InterruptedException e) {
                System.out.println("ImageLoader: ridiculous image; " + e.getMessage());
            }
            offScreenBuffer.getGraphics().drawImage(theImage, 0, 0, applet);
            ++x;
        }
    }

    public Image getImage(String name) {
        Image image = (Image)this.table.get(name);
        if (image == null) {
            System.out.println("ImageLoader.getImage: no such image \"" + name + "\" loaded");
        }
        return image;
    }

    public void dispose() {
        this.applet = null;
        this.table = null;
    }
}

